#include "StdAfx.h"
#include ".\workspaceaccess.h"
#include ".\workspace.h"

CWorkspaceAccess::CWorkspaceAccess(void)
{
	m_path = "";
	m_root = NULL;
}

CWorkspaceAccess::CWorkspaceAccess(CWorkspace *root,CString path)
{
	//	m[hpX֕ϊ
	if(path.GetLength() >= 2)
	{
		if(path.Right(2) != "::")
			path += "::";
	}
	else
		path += "::";

	m_path = path;
	m_root = root;
}

CWorkspaceAccess::~CWorkspaceAccess(void)
{
}

/*********************************************************
	Ȃ
**********************************************************/
//!	Sf[^NA
void CWorkspaceAccess::Clear(void)
{
	ASSERT(m_root != NULL);

	m_root->Clear(m_path);
}


/*!
	
*/
void CWorkspaceAccess::Copy(CWorkspaceAccess &other)
{
	ASSERT(m_root != NULL);

	m_root->Copy(m_path,other.m_path,other.m_root);
}


/*!
	ANZXNX擾
*/
CWorkspaceAccess CWorkspaceAccess::GetAccess(CString subPath)
{
	ASSERT(m_root != NULL);

	return CWorkspaceAccess(m_root,m_path + subPath);
}


/*!
	[g擾
*/
CWorkspace * CWorkspaceAccess::GetRoot()
{
	return(m_root);
}

/*!
	O擾
*/
CString CWorkspaceAccess::GetNodeName()
{
	//	̂Q
	CString	path = m_path;
	if(path.Right(2) == "::")
		path = path.Left(path.GetLength() - 2);

	int index = path.ReverseFind(_T(':'));
	if(index == -1)
		return(path);
	return(path.Mid(index + 1));
}

/*********************************************************
	f[^擾ݒ菈
**********************************************************/
/*!
	f[^̐ݒ()
*/
void CWorkspaceAccess::SetKeyStr(CString key, CString data,int noCase)
{
	ASSERT(m_root != NULL);

	m_root->SetKeyData(m_path + key,data);
}


/*!
	f[^̐ݒ(int)
*/
void CWorkspaceAccess::SetKeyInt(CString key, int data,int noCase)
{
	ASSERT(m_root != NULL);

	char	buf[80] = "";
	_itoa_s(data, buf, 80, 10);
	m_root->SetKeyData(m_path + key, buf);
}


/*!
	f[^̐ݒ(int64)
*/
void CWorkspaceAccess::SetKeyInt64(CString key, __int64 data,int noCase)
{
	ASSERT(m_root != NULL);

	char	buf[80] = "";
	_i64toa_s(data, buf, 80, 10);
	m_root->SetKeyData(m_path + key, buf);
}


/*!
	f[^̐ݒ(DWORD)
*/
void CWorkspaceAccess::SetKeyDWORD(CString key, DWORD data,int noCase)
{
	ASSERT(m_root != NULL);

	char	buf[80] = "";
	_ui64toa_s(data, buf, 80, 10);
	m_root->SetKeyData(m_path + key, buf);
}



/*!
	f[^̎擾()
*/
CString CWorkspaceAccess::GetKeyStr(CString key, CString defaultData,int noCase)
{
	ASSERT(m_root != NULL);

	return(m_root->GetKeyData(m_path + key,defaultData,noCase));
}


/*!
	f[^̎擾(int)
*/
int CWorkspaceAccess::GetKeyInt(CString key, int defaultData,int noCase)
{
	ASSERT(m_root != NULL);

	char	buf[80];
	_itoa_s(defaultData,buf,80,10);
	CString ret = m_root->GetKeyData(m_path + key,buf,noCase);
	return(atoi(ret));
}


/*!
	f[^̎擾(int64)
*/
__int64 CWorkspaceAccess::GetKeyInt64(CString key, __int64 defaultData,int noCase)
{
	ASSERT(m_root != NULL);

	char	buf[80];
	_i64toa_s(defaultData,buf,80,10);
	CString ret = m_root->GetKeyData(m_path + key,buf,noCase);
	return(_atoi64(ret));
}


/*!
	f[^̎擾(DWORD)
*/
DWORD CWorkspaceAccess::GetKeyDWORD(CString key, DWORD defaultData,int noCase)
{
	ASSERT(m_root != NULL);

	char	buf[80];
	_ui64toa_s(defaultData,buf,80,10);
	CString ret = m_root->GetKeyData(m_path + key,buf,noCase);
	return((DWORD)_atoi64(ret));
}

/*********************************************************
	KeyɊւ鏈
**********************************************************/
/*!
	L[擾
*/
int CWorkspaceAccess::GetKeyCount()
{
	ASSERT(m_root != NULL);

	return(m_root->GetKeyCount(m_path));
}


/*!
	SẴL[𕶎ƂĎ擾
*/
int CWorkspaceAccess::GetAllKey(CStringArray &list)
{
	ASSERT(m_root != NULL);

	return(m_root->GetAllKey(m_path,list));
}


/*!
	SẴL[Rs[
*/
void CWorkspaceAccess::CopyAllKeys(CKeyDataArray &keyData)
{
	ASSERT(m_root != NULL);

	m_root->CopyAllKeys(m_path,keyData);
}

/*!
	f[^̍폜
*/
void CWorkspaceAccess::DeleteKey(CString key)
{
	ASSERT(m_root != NULL);

	m_root->DeleteKey(m_path + key);
}

/*!
	񒆂̃L[f[^ɒu擾
*/
CString CWorkspaceAccess::GetKeySwapString(CString str,CString noData, IWorkspaceAutoSwapPtr tempSwap)
{
	ASSERT(m_root != NULL);

	return(m_root->GetKeySwapString(m_path, str, noData, tempSwap));
}


/******************************************************
	Tum[hɊւ鏈
*******************************************************/
/*!
	m[h폜
*/
void CWorkspaceAccess::DeleteNode(CString name)
{
	ASSERT(m_root != NULL);

	m_root->DeleteNode(m_path + name);
}


/*!
	Tum[h𓾂
*/
int CWorkspaceAccess::GetSubNodeCount()
{
	ASSERT(m_root != NULL);

	return(m_root->GetSubNodeCount(m_path));
}


/*!
	SẴTum[h𕶎ƂĎ擾
*/
int CWorkspaceAccess::GetAllSubNode(CStringArray &list)
{
	ASSERT(m_root != NULL);

	return(m_root->GetAllSubNode(m_path,list));
}


