#include "StdAfx.h"
#include ".\workspacenode.h"

//////////////////////////////////////////////////////////////////////////////////////////
//	Ȃ
//////////////////////////////////////////////////////////////////////////////////////////
CWorkspaceNode::CWorkspaceNode(void)
{
}

CWorkspaceNode::CWorkspaceNode(CString name)
{
	m_nodeName = name;
}

CWorkspaceNode::~CWorkspaceNode(void)
{
}

//	Rs[Iy[^
void CWorkspaceNode::operator=(const CWorkspaceNode &other)
{
	//	f[^̃Rs[
	m_nodeName = other.m_nodeName;
	m_keyData = other.m_keyData;
	m_subNode = other.m_subNode;

}

//	SăNA
void CWorkspaceNode::Clear(void)
{
	//	f[^폜
	m_keyData.RemoveAll();
	m_subNode.RemoveAll();
}


//////////////////////////////////////////////////////////////////////////////////////////
//	Keyɑ΂鏈(Public)
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	f[^̐ݒ

	̃m[h̃f[^ɑ΂ANZX
*/
void CWorkspaceNode::SetKeyData(CString &key, CString &data,int noCase)
{
	int	index = FindKeyIndex(key,noCase);
	if(index == -1)
	{
		m_keyData.Add(key,data);
	}
	else
	{
		m_keyData[index].m_data = data;
	}
}

/*!
	f[^̎擾

	̃m[h̃f[^ɑ΂ANZX
*/
CString CWorkspaceNode::GetKeyData(CString &key, CString &defaultData, int noCase)
{
	int	index = FindKeyIndex(key,noCase);
	if(index == -1)
	{
		return(defaultData);
	}
	else
	{
		return(m_keyData[index].m_data);
	}
}


/*!
	f[^̍폜

	̃m[h̃f[^ɑ΂ANZX
*/
void CWorkspaceNode::DeleteKey(CString &key)
{
	int index = FindKeyIndex(key,FALSE);
	if(index != -1)
		m_keyData.RemoveAt(index);
}


/*!
	L[擾
*/
int CWorkspaceNode::GetKeyCount()
{
	return((int)m_keyData.GetSize());
}

/*!
	SẴL[𕶎ƂĎ擾
*/
int CWorkspaceNode::GetAllKey(CStringArray &list)
{
	list.RemoveAll();

	int count = (int)m_keyData.GetSize();
	for(int i=0;i<count;i++)
		list.Add(m_keyData[i].m_key);

	return(count);
}


/*!
	SẴL[Rs[
*/
void CWorkspaceNode::CopyAllKeys(CKeyDataArray &keyData)
{
	keyData.Copy(m_keyData);
}


/*!
	񒆂̃L[f[^ɒu擾

	%Key-Name% AYL[̃f[^Œu܂
	noDataݒ肳ĂꍇAȂꍇ́AnoDataɒu܂
*/
CString CWorkspaceNode::GetKeySwapString(CString str,CString noData)
{
	int	count = (int)m_keyData.GetSize();

	//	S
	for(int i=0;i<count;i++)
	{
		/*
		int index = str.Find("%" + m_keyData[i].m_key + "%");

		for(int j=0;j<100 && index != -1;j++)
		{
			str = str.Mid(0,index) + m_keyData[i].m_data + str.Mid(index + 2 + m_keyData[i].m_key.GetLength());
			index = str.Find("%" + m_keyData[i].m_key + "%");
		}
		*/

		str.Replace("%" + m_keyData[i].m_key + "%",m_keyData[i].m_data);
	}

	//	YȂu폜
	if(!noData.IsEmpty() && noData.Find("%") == -1)
	{
		CString	tmp;
		for(int i=0;i<1000;i++)
		{
			int index = str.Find("%");
			if(index == -1)
			{
				tmp += str;
				break;
			}
			
			tmp += str.Mid(0,index);
			str = str.Mid(index+1);

			int index2 = str.Find("%");
			if(index == -1)
			{
				tmp += str;
				break;
			}

			//	%%?
			if(index2==0)
			{
				tmp += "%";
			}
			else
			{
				tmp += noData;

			}

			str = str.Mid(index2+1);
		}
		str = tmp;
	}

	return(str);
}

/*!
	L[
*/
int CWorkspaceNode::FindKeyData(CString sData, int noCase)
{
	if(noCase)
	{
		for(int i=0;i<m_keyData.GetSize();i++)
			if(sData.CompareNoCase(m_keyData[i].m_data) == 0)
				return(i);
	}
	else
	{
		for(int i=0;i<m_keyData.GetSize();i++)
			if(sData == m_keyData[i].m_data)
				return(i);
	}

	return(-1);
}

/*!
	L[
*/
int CWorkspaceNode::FindKeyDataPath(CString path, int eqPath)
{
	if(eqPath)
	{
		return(FindKeyData(path, TRUE));
	}
	else
	{
		//	r
		for(int i=0;i<m_keyData.GetCount();i++)
		{
			if(m_keyData[i].m_data.CompareNoCase(path.Left(m_keyData[i].m_data.GetLength())) == 0)
				return(i);
		}

		return(-1);
	}
}
	


//////////////////////////////////////////////////////////////////////////////////////////
//	Keyɑ΂鏈(Protect)
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	Leaf̌
*/
int CWorkspaceNode::FindKeyIndex(CString &key,int noCase)
{
	int	count = (int)m_keyData.GetSize();

	if(!noCase)
	{
		for(int i=0;i<count;i++)
		{
			if(m_keyData[i].m_key == key)
				return(i);
		}
	}
	else
	{
		for(int i=0;i<count;i++)
		{
			if(m_keyData[i].m_key.CompareNoCase(key) == 0)
				return(i);
		}
	}
	return -1;
}

//////////////////////////////////////////////////////////////////////////////////////////
//	Tum[hɑ΂鏈(Public)
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	Tum[h
*/
CWorkspaceNode *CWorkspaceNode::GetSubNode(CString path, CString &key)
{
	CString	topPath,subPath;
	if(ParsePath(path,topPath,subPath) == 0)
	{
		//	
		key = subPath;
		return this;
	}
	else
	{
		//	̃Tum[h
		int index = FindSubNodeIndex(topPath);
		if(index == -1)
		{
			//	Aǉ
			index = (int)m_subNode.GetSize();
			m_subNode.Add(CWorkspaceNode(topPath));
		}

		return(m_subNode[index].GetSubNode(subPath,key));	//	ɉ
	}

}

/*!
	̃Tum[h
*/
void CWorkspaceNode::AddSubNode(CString path, CString &key)
{
	CString	topPath,subPath;
	if(ParsePath(path,topPath,subPath) == 0)
	{
		//	Ώ̂EE
		return;
	}
	else
	{
		//	̃Tum[h
		int index = FindSubNodeIndex(topPath);
		if(index == -1)
		{
			//	Aǉ
			index = (int)m_subNode.GetSize();
			m_subNode.Add(CWorkspaceNode(topPath));
		}

		//	ɉʂǉ
		m_subNode[index].AddSubNode(subPath,key);
	}

}


/*!
	m[h폜

	# ֐łSCOPE_LOCKgp֎~II
	# fbhbN
*/
void CWorkspaceNode::DeleteNode(CString name)
{
	int index = FindSubNodeIndex(name);
	if(index != -1)
		m_subNode.RemoveAt(index);
}


/*!
	Tum[h𓾂
*/
int CWorkspaceNode::GetSubNodeCount()
{
	return((int)m_subNode.GetSize());
}


/*!
	SẴTum[h𕶎ƂĎ擾

	̃Tum[ĥ݂łB
	ʃm[hւ͌ɍs܂
*/
int CWorkspaceNode::GetAllSubNode(CStringArray &list)
{
	list.RemoveAll();

	int count = (int)m_subNode.GetSize();
	for(int i=0;i<count;i++)
		list.Add(m_subNode[i].m_nodeName);

	return(count);
}



//////////////////////////////////////////////////////////////////////////////////////////
//	Tum[hɑ΂鏈(Protected)
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	Tum[h
*/
int CWorkspaceNode::FindSubNodeIndex(CString name)
{
	for(int i=0;i<m_subNode.GetSize();i++)
	{
		if(m_subNode[i].m_nodeName == name)
			return(i);
	}
	return -1;
}


//////////////////////////////////////////////////////////////////////////////////////////
//	̑̊֐(Protect)
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	pX(u::v؂𕪉)

	\param path		pX
	\param topPath	gbvx̃pX
	\param subPath	c
	\return			0:̃L[A1:܂TuL[
*/
int CWorkspaceNode::ParsePath(CString path, CString & topPath, CString & subPath)
{
	int	index = path.Find("::");
	if(index == -1)
	{
		topPath.Empty();
		subPath = path;
		return(0);
	}
	else if(index == 0)
	{
		topPath.Empty();
		subPath = path.Mid(index + 2);
		return(0);
	}
	else
	{
		topPath = path.Mid(0,index);
		subPath = path.Mid(index + 2);
		return(1);
	}
}


/******************************************************
	o͂Ɋւ鏈
*******************************************************/
/*!
	Tum[h쐬
*/
CWorkspaceNode *CWorkspaceNode::AddNewSubNode(CString name)
{
	if(FindSubNodeIndex(name) != -1)
		return(NULL);

	m_subNode.Add(CWorkspaceNode(name));
	return &m_subNode[m_subNode.GetSize()-1];
}


/*!
	Tum[hCfbNXŎ擾
*/
CWorkspaceNode *CWorkspaceNode::GetSubNodeByIndex(int index)
{
	if(index < 0 || index >= m_subNode.GetCount())
		return(NULL);

	return(&m_subNode[index]);
}

/*!
	L[CfbNXŎ擾
*/
CKeyData *CWorkspaceNode::GetKeyByIndex(int index)
{
	if(index < 0 || index >= m_keyData.GetCount())
		return(NULL);

	return(&m_keyData[index]);
}

