#pragma once

#include "SortArray.h"

class CWorkspaceNode;
typedef CSortArray<CWorkspaceNode,CWorkspaceNode&>	CWorkspaceNodeArray;


/*!
	[NXy[X̃m[hێNX
*/
class CWorkspaceNode
{
	friend class CWorkspaceXMLReader;
	friend class CWorkspaceXMLWriter;

public:
	CWorkspaceNode(void);
	CWorkspaceNode(CString name);
	~CWorkspaceNode(void);

	/*********************************************************
		Ȃ
	**********************************************************/
	//!	CArrayŗp邽߂́ARs[Zq
	void operator=(const CWorkspaceNode &other);

	//!	Sf[^NA
	void Clear(void);

	//!	m[h̐ݒ
	void SetNodeName(CString name) { m_nodeName = name; };

	//!	m[h̎擾
	CString GetNodeName() { return(m_nodeName); };


	/*********************************************************
		KeyɊւ鏈
	**********************************************************/
	//!	f[^̐ݒ
	void SetKeyData(CString &key, CString &data,int noCase);

	//!	f[^̎擾
	CString GetKeyData(CString &key, CString &defaultData, int noCase);

	//!	f[^̍폜
	void DeleteKey(CString &key);

	//!	L[擾
	int GetKeyCount();

	//!	SẴL[𕶎ƂĎ擾
	int GetAllKey(CStringArray &list);

	//!	SẴL[Rs[
	void CopyAllKeys(CKeyDataArray &keyData);

	//!	񒆂̃L[f[^ɒu擾
	CString GetKeySwapString(CString str,CString noData);

	//!	L[
	int FindKeyData(CString sData, int noCase = FALSE);

	//!	L[
	int FindKeyDataPath(CString path, int eqPath = FALSE);

	/******************************************************
		Tum[hɊւ鏈
	*******************************************************/
	//!	Tum[h
	CWorkspaceNode *GetSubNode(CString path, CString &key);

	//!	Tum[hǉ
	void AddSubNode(CString path, CString &key);

	//!	m[h폜
	void DeleteNode(CString name);

	//!	Tum[h𓾂
	int GetSubNodeCount();

	//!	SẴTum[h𕶎ƂĎ擾
	int GetAllSubNode(CStringArray &list);


protected:
	/******************************************************
		o͂Ɋւ鏈
	*******************************************************/
	//!	Tum[h쐬
	CWorkspaceNode *AddNewSubNode(CString name);

	//!	Tum[hCfbNXŎ擾
	CWorkspaceNode *GetSubNodeByIndex(int index);

	//!	L[CfbNXŎ擾
	CKeyData *GetKeyByIndex(int index);

protected:
	/******************************************************
		KeyɊւ鏈
	*******************************************************/
	//!	Key̌
	int FindKeyIndex(CString &key,int noCase);

	/******************************************************
		Tum[hɊւ鏈
	*******************************************************/
	//!	Tum[h
	int FindSubNodeIndex(CString name);

	/******************************************************
		̑̊֐
	*******************************************************/
	//!	pX̉
	int ParsePath(CString path, CString & topPath, CString & subPath);


protected:
	//!	̃m[h̎f[^
	CKeyDataArray			m_keyData;

	//!	Tum[g
	CWorkspaceNodeArray		m_subNode;

	//!	̃m[h̖O
	CString					m_nodeName;
};

