#include "StdAfx.h"
#include ".\workspacestringlist.h"
#include "workspace.h"

CWorkspaceStringList::CWorkspaceStringList(CString listName)
{
	m_listName = listName;
}

CWorkspaceStringList::~CWorkspaceStringList(void)
{
}

CWorkspaceStringList::CWorkspaceStringList(CWorkspaceAccess &other, CString listName)
{
	m_listName = listName;
	CWorkspaceAccess::operator=(other.GetAccess(listName));
}

//////////////////////////////////////////////////////////////////////////////
//	擾
//////////////////////////////////////////////////////////////////////////////
/*!
	̎擾
*/
int CWorkspaceStringList::GetItemCount()
{
	return(GetKeyCount());
}

/*!
	ACe̎擾
*/
CString CWorkspaceStringList::GetItem(int index)
{
	//	SẴTum[h擾
	CStringArray	list;
	GetAllKey(list);

	//	Ώۂ擾
	return(GetKeyStr(list[index],""));
}

/*!
	ACe̐ݒ
*/
void CWorkspaceStringList::SetItem(int index, CString str)
{
	//	SẴTum[h擾
	CStringArray	list;
	GetAllKey(list);

	//	Ώۂ㏑
	SetKeyStr(list[index], str);
}

/*!
	ACeǉ
*/
void CWorkspaceStringList::AddNewItem(CString str, int checkExist, int noCase)
{
	//	dȂĂH
	if(checkExist)
		if(FindIndex(str, noCase) != -1)
			return;

	int itemNo = 0;
	CString	name;

	//	dȂĂȂOT
	CStringArray	list;
	GetAllKey(list);
	while(1)
	{
		//	Ȃ
		int loopFlag = 0;
		name.Format("%s_%04d", m_listName, itemNo);
		for(int i=0; i<list.GetSize(); i++)
		{
			if(name.CompareNoCase(list[i]) == 0)
				loopFlag = 1;
		}

		//	Ȃ
		if(loopFlag == 0)
			break;

		//	
		itemNo ++;
	}
	
	SetKeyStr(name, str);
}

/*!
	ACe̍폜
*/
void CWorkspaceStringList::DeleteItem(int index)
{
	//	SẴTum[h擾
	CStringArray	list;
	GetAllKey(list);

	//	Ώۂ폜
	DeleteKey(list[index]);
}

/*!
	܂Ƃ߂Ēǉ
*/
void CWorkspaceStringList::AddList(CStringArray &list, int checkExist, int noCase)
{
	for(int i=0;i<list.GetSize();i++)
		AddNewItem(list[i], checkExist, noCase);
}

/*!
	܂Ƃ߂Ď擾
*/
void CWorkspaceStringList::GetList(CStringArray &list)
{
	list.RemoveAll();

	//	SẴTum[h擾
	CKeyDataArray	keyList;
	CopyAllKeys(keyList);

	for(int i=0;i<keyList.GetSize();i++)
		list.Add(keyList[i].m_data);
}

/*!
	
*/
int CWorkspaceStringList::FindIndex(CString str, int noCase)
{
	return(m_root->FindKeyData(m_path, str, noCase));
}


/*!
	pX
*/
int CWorkspaceStringList::FindPath(CString path, int eqPath)
{
	return(m_root->FindKeyDataPath(m_path, path, eqPath));
}
