#pragma once
#include "Workspace.h"
#include "SyncObject.h"

/*!
	VKڑ
*/
class CAcceptedSocket
{
public:
	CAcceptedSocket()
	{
		m_rawSocket = NULL;
		m_rawSocketType = 0;
	}

	//!	ݒ肵ď
	CAcceptedSocket(SOCKET socket, int socketType)
	{
		m_rawSocket = socket;
		m_rawSocketType = socketType;
	}

	//!	ڑE
	void Abort()
	{
		if(m_rawSocket != NULL)
		{
			closesocket(m_rawSocket);
			m_rawSocket = NULL;
		}
	}

	//!	ݒ
	void SetSocket(SOCKET socket, int socketType)
	{
		m_rawSocket = socket;
		m_rawSocketType = socketType;
	}

	//!	擾(\Pbg)
	SOCKET GetSocket()
	{
		return m_rawSocket;
	}

	//!	擾(^Cv)
	SOCKET GetSocketType()
	{
		return m_rawSocketType;
	}

protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	\Pbg
	SOCKET	m_rawSocket;

	//!	\Pbg^Cv
	int		m_rawSocketType;
};



/*!
	ڑ擾IF
*/
class IAcceptedSockeQueueAccess
{
public:
	//!	擾
	virtual CAcceptedSocket GetNewConnection() = 0;

	//!	Z}tH擾
	virtual HANDLE GetSemaphore() = 0;

	//!	݂̕ێ擾
	virtual int GetCurrentQueueCount() = 0;
};


/*!
	VKڑL[
*/
class CAcceptedSocketQueue : public IAcceptedSockeQueueAccess
{
public:
	CAcceptedSocketQueue(void);
	virtual ~CAcceptedSocketQueue(void);

	///////////////////////////////////////////////////////////////////
	//	C^[tF[X
	///////////////////////////////////////////////////////////////////
	//!	Jn
	void Start() {};

	//!	I
	void Stop();

	//!	ǉ
	int AddNewConnection(CAcceptedSocket newConnection);

	//!	ő吔ݒ
	void SetMaxQueue(int max);

	//!	L
	void EnableQueue(int enable);

	//!	IClientConnectionQueuePtr擾
	IAcceptedSockeQueueAccess *GetIAcceptedSockeQueueAccesse() { return this; };

protected:
	///////////////////////////////////////////////////////////////////
	//	IAcceptedSockeQueueAccesspC^tF[X
	///////////////////////////////////////////////////////////////////
	//!	擾
	virtual CAcceptedSocket GetNewConnection();

	//!	Z}tH擾
	virtual HANDLE GetSemaphore() { return m_semaphore; };

	//!	݂̕ێ擾
	int GetCurrentQueueCount();

protected:
	///////////////////////////////////////////////////////////////////
	//	oϐ
	///////////////////////////////////////////////////////////////////
	//!	bN
	CCriticalSection		m_scopeLock;

	//!	L[{
	CList<CAcceptedSocket>	m_queue; 

	//!	Z}tH
	CSyncSemaphore			m_semaphore;

	//!	őێ
	int						m_maxQueue;

	//!	L
	int						m_enable;
};
