#include "StdAfx.h"
#include "cgiresponse.h"
#include "connection.h"
#include "Dir.h"
#include "intervaltimer.h"

CCGIResponse::CCGIResponse(CServer *server,CWorkspaceAccess context,CRequest request,CAlias alias,CConnectionInterrupt interrupt)
: CNormalResponse(server,context,request,alias),
  m_subProcess(server,interrupt), m_stdOutStartIndex(0),
  m_interrupt(interrupt)
{
	//	͖Ƃ
	if(alias.IsExist()==0 && alias.IsExtarExist()==0)
		throw new CSystemResponse(server,context,"w肳ꂽt@C݂͑܂",404);

	//	\bhGET/POST/HEAD
	if(request.GetMethod() != "GET" && request.GetMethod() != "HEAD" && request.GetMethod() != "POST")
		throw new CSystemResponse(server,context,"ΉĂȂ\bhł",405);

	if(alias.IsExtarExist())
		m_target = alias.GetExtraTarget();
	else
		m_target = alias.GetTarget();
}

CCGIResponse::~CCGIResponse(void)
{
}

/*
	1:

*/
void CCGIResponse::PreCreateResponse()
{
	__int64	recvLen = m_request.GetOptionAccess().GetConfig("Content-length",0,TRUE);

	//	MTCYݒ
	if(recvLen > 65536)
		m_subProcess.m_stdin.SetGrowSize((int)recvLen);
}

/*
	2:Mf[^̐ݒ(JԂ)

*/
void CCGIResponse::SetNextData(CBuffer &data)
{
	//	StdInobt@ɒǉ
	m_subProcess.m_stdin += data;
}


//	3:X|X̐
void CCGIResponse::CreateResponse()
{
	CString	threadID = m_context.GetConfig("ThreadName","");

	//	R}h擾
	CString	command = GetCommandString();

	//	CGI
	m_subProcess.AddCGIServerEnvironment(m_server,m_context,m_request,m_alias);

	//	REDIRECT_STATUS
	if(command.Left(m_target.GetLength()).CompareNoCase(m_target) != 0)
		m_subProcess.AddEnvironment("REDIRECT_STATUS=200");

	try
	{
		//	vZXs
		m_subProcess.RunSubProcess(command,CDir::PathToDir(m_target),threadID);
	}
	catch(CSubProcessException err)
	{
		ThrowCGIError("CGIsG[ : " + err.m_info);
	}

	//	ŏ̂Ps擾
	CString	header = GetHeader();

	//	
	CWorkspace			option;
	CWorkspaceAccess	optionAccess = option.GetAccess("Option");
	ParseHeader(header,optionAccess);

	if(optionAccess.GetKeyCount() == 0)
		ThrowCGIError("CGIG[ : CGIwb_[o͂܂ł");

	//	Xe[^XR[hH
	if(optionAccess.GetConfig("Status","",TRUE) != "")
	{
		CString status = optionAccess.GetConfig("Status","",TRUE);
		
		if(!status.IsEmpty())
		{
			int	temp = 0;
			CString code = status.Tokenize(" ",temp);

			//	Xe[^XR[h̐ݒ
			if(atoi(code) >= 100)
				SetResponseCode(atoi(code));
		}
	}
	
	//	^Cv́H
	if(optionAccess.GetConfig("Location","",TRUE) != "")
	{
		//	gIvVݒ
		m_responseInfo.SetConfig("CGIHeader",optionAccess.GetConfig("CGIHeader",""));

		//	ړ
		CString location = optionAccess.GetConfig("Location","",TRUE);
		CSystemResponse *move = new CSystemResponse(m_server,m_context,location + " ɈړĂ",301);
		move->m_responseOptions.SetConfig("Location",location);
		throw move;
	}
	else if(optionAccess.GetConfig("Content-Type","",TRUE) != "")
	{
		m_responseOptions.SetConfig("Content-Type",optionAccess.GetConfig("Content-Type","",TRUE));
	}
	else
		ThrowCGIError("CGIG[ : CGIwb_[o͂܂ł");

	//	gIvVݒ
	m_responseInfo.SetConfig("CGIHeader",optionAccess.GetConfig("CGIHeader",""));
}

//	4:X|XTCY̎擾
__int64 CCGIResponse::GetResponseSize()
{
	//	StdOutTCY
	return(m_subProcess.m_stdout.GetSize());
}


//	6:X|X̎擾
int CCGIResponse::GetNextData(CBuffer &data)
{
	int left = m_subProcess.m_stdout.GetSize() - m_stdOutStartIndex;

	if(left <= 0)
		return(0);

	if(left < data.GetSize())
		data.ReSize(left);

	data.BlockCopy(0,m_subProcess.m_stdout.GetPtr() + m_stdOutStartIndex,data.GetSize());
	m_stdOutStartIndex += data.GetSize();

	return(data.GetSize());
}

//	wb_[̈擾
CString CCGIResponse::GetHeader()
{
	int	maxHeader = 4096;
	if(maxHeader > m_subProcess.m_stdout.GetSize())
		maxHeader = m_subProcess.m_stdout.GetSize();

	//	wb_[𕶎
	CString	header;
	memcpy(header.GetBuffer(maxHeader + 1),m_subProcess.m_stdout.GetPtr(),maxHeader);
	header.ReleaseBufferSetLength(maxHeader);

	//	wb_[
	int index1 = header.Find("\r\n\r\n");
	int index2 = header.Find("\n\n");
	if(index1 != -1 && (index2 == -1 || index2 > index1))
	{
		header = header.Left(index1);
		m_subProcess.m_stdout.Remove(0,index1+4);
		return(header);
	}

	if(index2 != -1)
	{
		header = header.Left(index2);
		m_subProcess.m_stdout.Remove(0,index2+2);
		return(header);
	}

	return("");
}

//	wb_[
void CCGIResponse::ParseHeader(CString header,CWorkspaceAccess option)
{
	CString	line;
	int		counter = 0;

	while(TRUE)
	{
		line = header.Tokenize("\n",counter);
		if(line.IsEmpty())
			break;

		int index = line.Find(":");
		if(index == -1)
			continue;

		CString _key = line.Left(index);
		CString _data = line.Mid(index + 1);
		_key.Trim("\r\n");
		_data.Trim("\r\n");

		if(_key.CompareNoCase("Status") == 0)
			option.SetConfig("Status",_data);
		else if(_key.CompareNoCase("Content-Type") == 0)
			option.SetConfig("Content-Type",_data);
		else if(_key.CompareNoCase("Location") == 0)
			option.SetConfig("Location",_data);
		else
		{
			//	CGI-Extension header
			CString header = option.GetConfig("CGIHeader","");
			header += _key;
			header += ": ";
			header += _data;
			header += "\r\n";
			option.SetConfig("CGIHeader",header);
		}
	}
}


/*
	R}h擾
*/
CString	CCGIResponse::GetCommandString()
{
	CString file = m_context.GetConfig("ScriptCommand","");

	return(file);
}

//	G[
void CCGIResponse::ThrowCGIError(CString detail)
{
	//	G[񂪂H
	if(m_subProcess.m_stderr.GetSize() > 0)
	{
		CString	str;
		str.Format("-- ȉACGIvOɂG[ --\n\n%s",(CString)m_subProcess.m_stderr);
		throw new CSystemResponse(m_server,m_context,detail,500,str);
	}
#ifdef DEBUG
	else if(m_subProcess.m_stdout.GetSize() > 0)
	{
		CString	str;
		str.Format("-- ȉACGIvOɂG[ --\n\n%s",(CString)m_subProcess.m_stdout);
		throw new CSystemResponse(m_server,m_context,detail,500,str);
	}
#endif
	else
		throw new CSystemResponse(m_server,m_context,detail,500);
}

