#include "StdAfx.h"
#include "CommandRecvPipe.h"
#include "SyncObject.h"
#include "CommandPacket.h"

#define	SEND_TIME_OUT_MS	(5 * 1000)

//	Xe[^X
enum CP_STATUS
{
	CP_STATUS_START				= 0,
	CP_STATUS_SENDING_WELECOME	= 1,
	CP_STATUS_RECEIVING_COMMAND = 3,
	CP_STATUS_SENDING_RESPONSE	= 4,
	CP_STATUS_CLOSE				= -1,
};


CCommandRecvPipe::CCommandRecvPipe(void)
{
	m_status = CP_STATUS_START;
	SetTimeOut(SEND_TIME_OUT_MS);
}

CCommandRecvPipe::~CCommandRecvPipe(void)
{
}

//////////////////////////////////////////////////////////////////////////////////////////
//	
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	
*/
int CCommandRecvPipe::Init(CPipeServer *reciver, CPipeCommandExecuteBase *executer, HANDLE pipe, ULONG_PTR CompletionKey)
{
	//	Rs[
	m_reciver = reciver;
	m_executer = executer;

	//	pCv
	if(COverlapedPipe::Init(pipe, CompletionKey))
		return(-1);

	//	EFJbZ[W
	if(BuildWelcomeMessage(m_sendData))
		return(-1);

	//	EFJbZ[WMJn
	m_status = CP_STATUS_SENDING_WELECOME;
	if(StartWaitSend())
	{
		Close();
		return(-1);
	}

	return(0);
}

/*!
	I
*/
void CCommandRecvPipe::Close()
{
	COverlapedPipe::Close();

	SAFE_CLOSE_HANDLE(m_hPipe);
	m_status = CP_STATUS_CLOSE;
}


/*!
	
*/
int CCommandRecvPipe::PipeTask()
{
	//	
	if(EndOverlap())
	{
		Close();
		return(-1);
	}

	//	e
	switch(m_status)
	{
		//	EFJbZ[WM
		case CP_STATUS_SENDING_WELECOME:
		{
			//	R}hbZ[W҂
			m_status = CP_STATUS_RECEIVING_COMMAND;
			if(StartWaitRecv())
			{
				Close();
				return(-1);
			}
			break;
		}

		//	R}hbZ[WM
		case CP_STATUS_RECEIVING_COMMAND:
		{
			//	Ăяo
			if(OnRecvCommand(m_recvData, m_sendData))
			{
				Close();
				return(-1);
			}

			//	X|X𑗐MJn
			m_status = CP_STATUS_SENDING_RESPONSE;
			if(StartWaitSend())
			{
				Close();
				return(-1);
			}
			break;
		}

		//	R}hX|XM
		case CP_STATUS_SENDING_RESPONSE:
		{
			//	̃R}hbZ[W҂
			m_status = CP_STATUS_RECEIVING_COMMAND;
			if(StartWaitRecv())
			{
				Close();
				return(-1);
			}
			break;
		}

		default:
			return(-1);
	}

	return(0);
}


//////////////////////////////////////////////////////////////////////////////////////////
//	֐
//////////////////////////////////////////////////////////////////////////////////////////
/*!
	ؒf`FbN
*/
int CCommandRecvPipe::CheckDisconnect()
{
	//	ؒf
	if(m_hPipe == NULL)
		return(1);

	//	Ԑ̂鏈sH
	if(	m_status == CP_STATUS_SENDING_WELECOME || 
		m_status == CP_STATUS_SENDING_RESPONSE)
	{
		if(IsTimeout())
		{
			Close();
			return(1);
		}
	}

	return(0);
}

/*!
	EFJbZ[W
*/
int CCommandRecvPipe::BuildWelcomeMessage(CBuffer &sendData)
{
	//	T[oݒ
	CCommandPacket	welcome;
	welcome.SetCommand(_T("Welcome"));
	welcome.SetCommandOption(_T("ServerName"), _T(SERVER_NAME));
	welcome.SetCommandOption(_T("ServerVersion"), _T(SERVER_VER));
	welcome.SetCommandOption(_T("SupportedInterface"), _T(SERVER_SUPPORT_CONTROL_INTERFACE));

	welcome.ToBuffer(sendData);
	return(0);
}


/*!
	R}hĂяo
*/
int CCommandRecvPipe::OnRecvCommand(CBuffer &recvData, CBuffer &sendData)
{
	return m_executer->OnRecvCommand(m_recvData, m_sendData);
}

