#include "StdAfx.h"
#include "DigestAuthenticate.h"
#include "TextTools.h"
#include "Base64.h"
#include "CryptTools.h"

/////////////////////////////////////////////////////////////////////////////////////////
//	`FbN
/////////////////////////////////////////////////////////////////////////////////////////
/*!
	F؉

	\return AUTH_PARSE_STATUS_OK:OK, AUTH_PARSE_STATUS_NONE:FؖAAUTH_PARSE_STATUS_ERROR:ُȗv
*/
AUTH_PARSE_STATUS CDigestAuthenticate::ParseAuthMethod(CAuthenticateManager *manager, CAlias &alias, CRequest &request)
{
	//	F؃IvV擾
	CString authOptionLine = request.GetOptionAccess().GetConfig(_T("Authorization"), _T(""));
	authOptionLine.Trim();
	TRACE("Authorization: %s\n", authOptionLine);

	//	Fؖ
	if(authOptionLine.IsEmpty())
		return(AUTH_PARSE_STATUS_NONE);

	//	F؎擾
	CString	authMethod;
	CTextTools::GetToken(authOptionLine, authMethod, _T(" "), TRUE);

	//	F؃^Cv
	authMethod.MakeLower();
	request.GetAuthDetailAccess().SetKeyStr(_T("AuthMethod"), authMethod);

	//	F؃^Cv
	if(authMethod == _T("basic"))
	{
		//	
		if(ParseBasicAuth(authOptionLine, request))
			return(AUTH_PARSE_STATUS_ERROR);
	}
	else if(authMethod == _T("digest"))
	{
		//	
		if(ParseAuthOptionLine(authOptionLine, request))
			return(AUTH_PARSE_STATUS_ERROR);

		//	v`FbN
		if(CheckDigestAuthRequest(manager, alias, request))
			return(AUTH_PARSE_STATUS_ERROR);
	}
	else
		return(AUTH_PARSE_STATUS_ERROR);

	return(AUTH_PARSE_STATUS_OK);
}

/*!
	F؃`FbN

	\return FALSE:Fؕs, TRUE:FOK
*/
int CDigestAuthenticate::CheckAuthUser(CAuthenticateManager *manager, CAlias &alias, CRequest &request)
{
	if(request.GetAuthDetailAccess().GetKeyStr(_T("AuthMethod"), _T("")) == _T("basic"))
	{
		CString	passwd;
		if(GetUserPasswd(manager, alias, request.GetUser(), passwd))
		{
			if(request.GetPasswd() == passwd)
				return(TRUE);
		}
		return(FALSE);
	}
	else if(request.GetAuthDetailAccess().GetKeyStr(_T("AuthMethod"), _T("")) == _T("digest"))
	{
		//	_CWFXgF؏ڍ
		CWorkspaceAccess digestAuthOption = request.GetAuthDetailAccess().GetAccess(_T("DigestAuth"));

		//	nonce`FbN
		if(!manager->CheckNonce(digestAuthOption.GetKeyStr(_T("nonce"), _T(""))))
			return(FALSE);

		CString	passwd;
		if(GetUserPasswd(manager, alias, request.GetUser(), passwd))
		{
			//	nbV`FbN
			if(CheckDigestAuthResponse(alias, request, passwd))
				return(TRUE);
		}
		return(FALSE);
	}
	else
		return(FALSE);
}


/////////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////////
/*!
	F؃C擾(Basic)
*/
CString CDigestAuthenticate::GetBasicAuthOptionLine(CAlias &alias)
{
	CString	line = CTextTools::GetFormat(_T("Basic realm=\"%s\""), alias.GetPathInfo().GetKeyStr(_T("Info"), _T("")));
	return(line);
}


/*!
	F؃C擾(Digest)
*/
CString CDigestAuthenticate::GetDigestAuthOptionLine(CAuthenticateManager *manager, CAlias &alias)
{
	CString realm = GetRealm(alias.GetPathInfo().GetKeyStr(_T("Info"), _T("")));
	CString line = CTextTools::GetFormat(_T("Digest realm=\"%s\", nonce=\"%s\", algorithm=MD5, qop=\"auth\""), realm, manager->CreateNonce());
	return(line);
}



/////////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////////
/*!
	{F؂̏
*/
int CDigestAuthenticate::ParseBasicAuth(CString authLine, CRequest &request)
{
	//	Base64
	CString	userpass = CBase64::Decode64(authLine);

	//	
	int	index = userpass.Find(":");
	if(index == -1)
		return(-1);

	//	[U
	request.SetUser(userpass.Left(index));

	//	pX[h
	request.SetPasswd(userpass.Mid(index + 1));

	return(0);
}

/*!
	_CWFXgF؂̏ڍ׃`FbN
*/
int CDigestAuthenticate::CheckDigestAuthRequest(CAuthenticateManager *manager, CAlias &alias, CRequest &request)
{
	//	_CWFXgF؏ڍ
	CWorkspaceAccess digestAuthOption = request.GetAuthDetailAccess().GetAccess(_T("DigestAuth"));

	//	realmmF
	if(digestAuthOption.GetKeyStr(_T("realm"), _T("")) != GetRealm(alias.GetPathInfo().GetKeyStr(_T("Info"), _T(""))))
		return(-1);

	//	urimF(vňv΂悢)
	if(!CheckURIMatch(request.GetURI(), digestAuthOption.GetKeyStr(_T("uri"), _T(""))))
		return(-1);

	return(0);
}

/*!
	nbV擾
*/
int CDigestAuthenticate::CheckDigestAuthResponse(CAlias &alias, CRequest &request, CString passwd, CString tag)
{
	//	_CWFXgF؏ڍ
	CWorkspaceAccess digestAuthOption = request.GetAuthDetailAccess().GetAccess(_T("DigestAuth"));

	CString responseClient	= digestAuthOption.GetKeyStr(_T("response"), _T(""));
	CString nonce	= digestAuthOption.GetKeyStr(_T("nonce"), _T(""));
	CString user	= digestAuthOption.GetKeyStr(_T("username"), _T(""));
	CString realm	= digestAuthOption.GetKeyStr(_T("realm"), _T(""));
	CString nc		= digestAuthOption.GetKeyStr(_T("nc"), _T(""));
	CString cnonce	= digestAuthOption.GetKeyStr(_T("cnonce"), _T(""));
	CString qop		= digestAuthOption.GetKeyStr(_T("qop"), _T(""));
	CString uri		= digestAuthOption.GetKeyStr(_T("uri"), _T(""));
	CString method	= request.GetMethod();

	//	A1(MD5-HEX)
	CString	a1 = CCryptTools::GetMD5HexFromStr(user + _T(":") + realm + _T(":") + passwd);

	//	A2(MD5-HEX)
	CString	a2 = CCryptTools::GetMD5HexFromStr(method + _T(":") + uri);

	//	Response(MD5-HEX)
	CString	responseServer = CCryptTools::GetMD5HexFromStr(a1 + _T(":") + nonce + _T(":") + nc +  _T(":") + cnonce +  _T(":") + qop + _T(":") + a2);

	if(responseServer == responseClient)
		return(TRUE);
	return(FALSE);
}


/*!
	Authorization IvV𕪉
*/
int CDigestAuthenticate::ParseAuthOptionLine(CString optionLine, CRequest &request)
{
	//	_CWFXgF؏ڍ
	CWorkspaceAccess digestAuthOption = request.GetAuthDetailAccess().GetAccess(_T("DigestAuth"));

	//	ڍׂ擾
	CStringArray	optionArray;
	CTextTools::GetAllTokenDoubleQuotation(optionLine, optionArray, _T(","), TRUE);

	//	ڍׂ𕪉
	for(int i=0; i<optionArray.GetSize(); i++)
	{
		CString	pair = optionArray[i];

		//	= ŕ
		CString	key;
		if(CTextTools::GetToken(pair, key, _T("="), TRUE))
		{
			pair.Trim();

			//	ǉ
			if(!key.IsEmpty() && !pair.IsEmpty())
			{
				//	_uR[e[VO
				pair = CTextTools::RemoveDoubleQuotation(pair);

				//	_uR[e[VΒǉ
				if(key.Find(_T("\"")) == -1 &&  pair.Find(_T("\"")) == -1)
					digestAuthOption.SetKeyStr(key.MakeLower(), pair);
			}
		}
	}

	//	`FbN
	if(digestAuthOption.GetKeyStr(_T("username"), _T("")).IsEmpty())
		return(-1);
	if(!digestAuthOption.KeyIsExist(_T("realm")))
		return(-1);
	if(digestAuthOption.GetKeyStr(_T("nonce"), _T("")).IsEmpty())
		return(-1);
	if(digestAuthOption.GetKeyStr(_T("uri"), _T("")).IsEmpty())
		return(-1);
	if(digestAuthOption.GetKeyStr(_T("algorithm"), _T("")).CompareNoCase(_T("MD5")) != 0)
		return(-1);
	if(digestAuthOption.GetKeyStr(_T("qop"), _T("")).CompareNoCase(_T("auth")) != 0)
		return(-1);
	if(digestAuthOption.GetKeyStr(_T("nc"), _T("")).IsEmpty())
		return(-1);
	if(digestAuthOption.GetKeyStr(_T("cnonce"), _T("")).IsEmpty())
		return(-1);
	if(digestAuthOption.GetKeyStr(_T("response"), _T("")).IsEmpty())
		return(-1);

	//	[U
	request.SetUser(digestAuthOption.GetKeyStr(_T("username"), _T("")));
	return(0);
}


/*!
	[UEpX[h`FbN

	\return FALSE:Fؕs, TRUE:FOK
*/
int CDigestAuthenticate::GetUserPasswd(CAuthenticateManager *manager, CAlias &alias, CString userName, CString &passwd)
{
	CWorkspaceAccess	pathUser = alias.GetPathInfo().GetAccess("Users");

	//	pXɐݒ肳Ă郆[UmF
	CStringArray	userList;
	pathUser.GetAllKey(userList);
	for(int i=0;i<userList.GetSize();i++)
	{
		if(pathUser.GetConfig(userList[i], _T("")) == userName)
			return(manager->GetUserPasswd(userName, passwd));	//	[UEpX[hLmF
	}

	//	WindowsXP ΍
	int index = userName.Find("\\");
	if(index == -1)
		return(FALSE);
	userName = userName.Mid(index+1);

	//	xmF
	for(int i=0;i<userList.GetSize();i++)
	{
		if(pathUser.GetConfig(userList[i], _T("")) == userName)
			return(manager->GetUserPasswd(userName, passwd));	//	[UEpX[hLmF
	}

	return(FALSE);
}


/*!
	URÏvmF
*/
int CDigestAuthenticate::CheckURIMatch(CString serverURI, CString clientURI)
{
	if(serverURI.GetLength() <= clientURI.GetLength())
		if(serverURI == clientURI.Right(serverURI.GetLength()))
			return(TRUE);

	//	IE6΍
	CString	uriIE6;
	if(CTextTools::GetToken(serverURI, uriIE6, _T("?")))
	{
		if(uriIE6.GetLength() <= clientURI.GetLength())
			if(uriIE6 == clientURI.Right(serverURI.GetLength()))
				return(TRUE);
	}

	return(FALSE);
}


/*!
	realm擾
*/
CString CDigestAuthenticate::GetRealm(CString realmSrc)
{
	CStringW	str(realmSrc), ret;
	wchar_t		*ptr = str.GetBuffer(0);
	int			len = str.GetLength();

	//	u
	for(int i=0; i<len; i++)
	{
		if(*ptr >= 0x0080)
			ret += L"_";
		else
			ret += *ptr;
		*ptr++;
	}
	return(CStringA(ret));
}

