#include "StdAfx.h"
#include "ProtocolSocket.h"

#define	DEFAULT_TIMEOUT	(3 * 60 * 1000)

CProtocolSocket::CProtocolSocket(void)
{
	SetTimeout(DEFAULT_TIMEOUT);
}

CProtocolSocket::~CProtocolSocket(void)
{
}


//////////////////////////////////////////////////////////////////////////////////
//	o()
//////////////////////////////////////////////////////////////////////////////////
/*!
	M

	SẴf[^𑗐M܂ŃubN
*/
int CProtocolSocket::Send(char *data, int len)
{
	//	G[NA
	ClearError();

	//	M[v
	while(1)
	{
		//	Mobt@ɓ
		if(len > 0)
		{
			int ret = WriteBuf(data, len);
			data += ret;
			len -= ret;
		}
		else if(GetSendInBuf() == 0)
			return(0);

		//	M
		if(BlockingSend(m_timeoutMS) < 0)
			return(-1);
	}
}

/*!
	Mij

	SẴf[^𑗐M܂ŃubN
*/
int CProtocolSocket::SendString(CString str)
{
	int ret = Send(str.GetBuffer(0),str.GetLength());
	str.ReleaseBuffer();

	return(ret);
};

/*!
	MiCBinaryDataj
*/
int CProtocolSocket::SendBinary(CBinaryData &data)
{
	return(Send(data.GetPtr(), data.GetSize()));
}

/*!
	MiCBufferj
*/
int CProtocolSocket::SendBinary(CBuffer &data)
{
	return(Send(data.GetPtr(), data.GetSize()));
}


/*!
	M

	f[^M܂ŃubN	
*/
int CProtocolSocket::Recv(char *data, int len)
{
	//	G[NA
	ClearError();

	//	M̕Kv͂邩H
	if(GetRecvInBuf() == 0)
	{
		//	M
		if(BlockingRecv(m_timeoutMS) < 0)
			return(-1);
	}

	//	obt@ǂݏo
	return(ReadBuf(data, len));
}


/*!
	Mij

	f[^M܂ŃubN	
*/
int CProtocolSocket::RecvString(CString &str, int maxLen)
{
	int ret = Recv(str.GetBuffer(maxLen + 1), maxLen);
	if(ret < 0)
		str.ReleaseBufferSetLength(0);
	else
		str.ReleaseBufferSetLength(ret);

	return(ret);
}


/*!
	MiCBinaryDataj
*/
int CProtocolSocket::RecvBinary(CBinaryData &data, int maxSize)
{
	data.ReSize(maxSize);

	int ret = Recv(data.GetPtr(), maxSize);
	if(ret < 0)
		data.ReSize(0);
	else
		data.ReSize(ret);

	return(ret);
}


/*!
	MiCBufferj
*/
int CProtocolSocket::RecvBinary(CBuffer &data, int maxSize)
{
	data.ReSize(maxSize);

	int ret = Recv(data.GetPtr(), maxSize);
	if(ret < 0)
		data.ReSize(0);
	else
		data.ReSize(ret);

	return(ret);
}


//////////////////////////////////////////////////////////////////////////////////
//	vgR
//////////////////////////////////////////////////////////////////////////////////
/*!
	NGXgM҂
	NGXgo܂ŃubN

	\return TRUE->oAFALSE->^CAEgAؒf
*/
int CProtocolSocket::WaitNextRequest(int maxWaitTime)
{
	//	G[NA
	ClearError();

	//	Mobt@`FbN
	if(GetRecvInBuf() > 0)
		return(TRUE);

	//	Jn
	DWORD	start = GetTickCount();

	//	M܂Ń[v
	while(1)
	{
		//	Mobt@`FbN
		if(GetRecvInBuf() > 0)
			return(TRUE);

		//	ؒfH
		if(IsDisconnect())
		{
			CloseError(CBS_ERROR_CLOSE, "WaitNextRequest");
			return(FALSE);
		}

		//	ҋ@H
		DWORD	now = GetTickCount();
		if(now < start || start + maxWaitTime <= now)
			return(FALSE);

		//	M݂
		if(BlockingRecv(start + maxWaitTime - now) < 0)
			return(FALSE);
	}
}

/*!
	wb_M
	wb_M܂ŃubN	

	\return 0->A-1->G[
*/
int CProtocolSocket::RecvProtocolHeader(CString &head, CString endToken, int maxHeaderSize, int isPeek)
{
	//	G[NA
	ClearError();

	//	őTCY
	if(maxHeaderSize >= GetSendRecvBufSize())
		maxHeaderSize = GetSendRecvBufSize()-1;

	//	M[v
	while(1)
	{
		//	M?
		int ret = GetHeaderFromBuf(head, endToken, maxHeaderSize, isPeek);
		if(ret < 0)
			return(-1);
		else if(ret > 0)
			return(0);	//	

		//	M݂
		if(BlockingRecv(m_timeoutMS) < 0)
			return(-1);

		//	wb_ȂɐؒfH
		if(IsDisconnect())
		{
			CloseError(CBS_ERROR_CLOSE, "RecvProtocolHeader");
			return(-1);
		}
	}
}

/*!
	wb_`FbN
*/
int CProtocolSocket::GetHeaderFromBuf(CString &head, CString endToken, int maxHeaderSize, int isPeek)
{
	//	Mf[^擾
	if(PeekBufString(head, maxHeaderSize + 1) < 0)
		return(-1);

	//	wb_TCY`FbN
	if(head.GetLength() > maxHeaderSize)
	{
		CloseError(CPS_ERROR_RECV_HEADER_OVER_SIZE, "RecvProtocolHeader");
		return(-1);
	}

	//	Ă݂
	int index = head.Find(endToken);
	if(index != -1 && index <= maxHeaderSize - endToken.GetLength())
	{
		//	token܂
		index += endToken.GetLength();

		//	PeekMode?
		if(isPeek)
		{
			head = head.Left(index);
		}
		else
		{
			//	ǂݏo
			if(ReadBufString(head,index) < 0)
				return(-1);
		}

		return(1);	//	
	}

	return(0);	//	
}

//////////////////////////////////////////////////////////////////////////////////
//	obt@ANZXi)
//////////////////////////////////////////////////////////////////////////////////
/*!
	M()
*/
int CProtocolSocket::ReadBufString(CString &str,int maxLen)
{
	//	
	int ret = ReadBuf(str.GetBuffer(maxLen+1), maxLen);
	if(ret < 0)
		str.ReleaseBufferSetLength(0);
	else
		str.ReleaseBufferSetLength(ret);

	return(ret);
}

/*!
	obt@ȂM()
*/
int CProtocolSocket::PeekBufString(CString &str,int maxLen)
{
	//	
	int ret = PeekBuf(str.GetBuffer(maxLen+1),maxLen);
	if(ret < 0)
		str.ReleaseBufferSetLength(0);
	else
		str.ReleaseBufferSetLength(ret);

	return(ret);
}



//////////////////////////////////////////////////////////////////////////////////
//	G[
//////////////////////////////////////////////////////////////////////////////////
/*!
	G[R[h當擾
*/
CString CProtocolSocket::GetErrorString(int errorCode)
{
	switch(errorCode)
	{
	case CPS_ERROR_RECV_HEADER_OVER_SIZE:
		return(_T("sȃwb_M܂"));

	default:
		return(CBufferdSocket::GetErrorString(errorCode));
	}
}
