#pragma once
#include "openssl\ssl.h"
#include "SyncObject.h"
#include "Workspace.h"

/*!
	SSLReLXg
	OpenSSLgp
*/
class CSSLContext
{
public:
	CSSLContext(void);
	virtual ~CSSLContext(void);

	/////////////////////////////////////////////////////////////////////////////////////
	//	
	/////////////////////////////////////////////////////////////////////////////////////
	//!	
	void Start(CWorkspaceAccess setting);

	//!	~
	void Stop();

	/////////////////////////////////////////////////////////////////////////////////////
	//	擾
	/////////////////////////////////////////////////////////////////////////////////////
	//!	OpenSSLReLXg擾
	SSL_CTX *GetCTX();

protected:
	/////////////////////////////////////////////////////////////////////////////////////
	//	OpenSSL
	/////////////////////////////////////////////////////////////////////////////////////
	//!	
	void InitOpenSSL();

	//!	~
	void CloseOpenSSL();

	//!	_擾
	CString GetRandomString(int count);


	/////////////////////////////////////////////////////////////////////////////////////
	//	R[obN֐
	/////////////////////////////////////////////////////////////////////////////////////
	//!	pX[hR[obN
	static int Password_cb(char *buf,int num,int rwflag,void *userdata);

	//!	bNR[obN
	static void Locking_cb(int mode, int type,const char *file, int line);

	//!	XbhR[obN
	static unsigned long GetThreadId_cb();

	//!	pX[h擾
	CString GetPassword();

	/////////////////////////////////////////////////////////////////////////////////////
	//	Mutex
	/////////////////////////////////////////////////////////////////////////////////////
	//!	bN
	static void InitLock();

	//!	bN
	static void EndLock();

	/////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	/////////////////////////////////////////////////////////////////////////////////////
	//!	NeBJZNV
	CCriticalSection		m_scopeLock;

	//!	tO
	CInterlockCounter		m_init;

	//!	ݒ
	CWorkspaceAccess		m_setting;

	//!	OpenSSLReLXg
	SSL_CTX					*m_context;

	//!	OpenSSLʐM
	SSL_METHOD				*m_method;

	//!	vCx[gL[pX[h
	CString					m_password;
};
