#include "StdAfx.h"
#include "AddAuthorizedApp2.h"


/*!
	INetFwPolicy2g邩`FbN
*/
bool CAddAuthorizedApp2::CanUse()
{
	CComPtr<INetFwPolicy2>	fwPolicy2;

	HRESULT hResult = ::CoCreateInstance((REFCLSID)CLSID_NetFwPolicy2, 0, CLSCTX_INPROC_SERVER, (REFIID)IID_INetFwPolicy2, (LPVOID*)&fwPolicy2);
	if(!SUCCEEDED(hResult))
	{
		TRACE("Can not use INetFwPolicy2\n");
		return FALSE;
	}

	TRACE("Can use INetFwPolicy2\n");
	return TRUE;
}


/*!
	Vistaȍ~ǉ
*/
void CAddAuthorizedApp2::AddAppToFW(CString appName, CString appPath, CString description, bool setPublic)
{
	//	ŏɍ폜
	DelAppFromFW(appName);

	//	INetFwPolicy2擾
	CComPtr<INetFwPolicy2>	fwPolicy2;
	HRESULT hResult = ::CoCreateInstance((REFCLSID)CLSID_NetFwPolicy2, 0, CLSCTX_INPROC_SERVER, (REFIID)IID_INetFwPolicy2, (LPVOID*)&fwPolicy2);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwPolicy2擾ł܂"));

	//	[Xg擾
	CComPtr<INetFwRules>	existRules;
	hResult = fwPolicy2->get_Rules(&existRules);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwRules擾ł܂"));

	//	[
	CComPtr<INetFwRule>	newRule;
	hResult = ::CoCreateInstance((REFCLSID)CLSID_NetFwRule, 0, CLSCTX_INPROC_SERVER, (REFIID)IID_INetFwRule, (LPVOID*)&newRule);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwRule擾ł܂"));

	//	K
	long	profileBitmap = NET_FW_PROFILE2_DOMAIN | NET_FW_PROFILE2_PRIVATE;
	if(setPublic)
		profileBitmap = NET_FW_PROFILE2_ALL;

	//	[̃vpeBݒ
	newRule->put_Name(_bstr_t(appName));
	newRule->put_Description(_bstr_t(description));
	newRule->put_ApplicationName(_bstr_t(appPath));
	newRule->put_Protocol(NET_FW_IP_PROTOCOL_TCP);
	newRule->put_Enabled(VARIANT_TRUE);
	newRule->put_Profiles(profileBitmap);
	newRule->put_Action(NET_FW_ACTION_ALLOW);

	//	o^
	hResult = existRules->Add(newRule);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("[̓o^Ɏs܂"));
	TRACE("[o^܂\n");
}

/*!
	Vistaȍ~폜
*/
void CAddAuthorizedApp2::DelAppFromFW(CString appName)
{
	//	́H
	if(!RuleIsExist(appName))
		return;

	//	INetFwPolicy2擾
	CComPtr<INetFwPolicy2>	fwPolicy2;
	HRESULT hResult = ::CoCreateInstance((REFCLSID)CLSID_NetFwPolicy2, 0, CLSCTX_INPROC_SERVER, (REFIID)IID_INetFwPolicy2, (LPVOID*)&fwPolicy2);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwPolicy2擾ł܂"));

	//	[Xg擾
	CComPtr<INetFwRules>	existRules;
	hResult = fwPolicy2->get_Rules(&existRules);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwRules擾ł܂"));

	//	폜
	hResult = existRules->Remove(_bstr_t(appName));
	if(!SUCCEEDED(hResult))
		ThrowException(_T("[̍폜Ɏs܂"));
	TRACE("[폜܂\n");
}


/*!
	Vistaȍ~A݃`FbN
*/
bool CAddAuthorizedApp2::RuleIsExist(CString appName)
{
	//	INetFwPolicy2擾
	CComPtr<INetFwPolicy2>	fwPolicy2;
	HRESULT hResult = ::CoCreateInstance((REFCLSID)CLSID_NetFwPolicy2, 0, CLSCTX_INPROC_SERVER, (REFIID)IID_INetFwPolicy2, (LPVOID*)&fwPolicy2);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwPolicy2擾ł܂"));

	//	[Xg擾
	CComPtr<INetFwRules>	existRules;
	hResult = fwPolicy2->get_Rules(&existRules);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwRules擾ł܂"));

	//	Aṽ[擾
	CComPtr<INetFwRule>		appRule;
    hResult = existRules->Item(_bstr_t(appName), &appRule);
	if(!SUCCEEDED(hResult))
		return FALSE;
	return TRUE;
}


/*!
	G[𓊂
*/
void CAddAuthorizedApp2::ThrowException(CString errorInfo)
{
	TRACE(_T("Error : %s\n"), errorInfo);
	throw CAddAuthorizedAppException(errorInfo);
}
