#include "StdAfx.h"
#include "icf.h"
#include "PathTools.h"
#include "AddAuthorizedApp.h"
#include "AddAuthorizedApp2.h"


////////////////////////////////////////////////////////////////////////
//	
////////////////////////////////////////////////////////////////////////
/*!
	ǉ
*/
void CICF::AddApp(int serviceMode, int silent)
{
	CString serverFileName = _T(SERVER_FILE_NAME);
	if(serviceMode)
		serverFileName = _T(SERVER_FILE_NAME_SERVICE);

	try
	{
		if(CAddAuthorizedApp2::CanUse())
			CAddAuthorizedApp2::AddAppToFW(_T(SERVER_NAME), CPathTools::GetAppPath() + serverFileName, _T(SERVER_DESCRIPTION), TRUE);
		else if(CAddAuthorizedApp::CanUse())
			CAddAuthorizedApp::AddAppToFW(_T(SERVER_DESCRIPTION), CPathTools::GetAppPath() + serverFileName);
		else
			throw CAddAuthorizedAppException(_T("Windowst@CA[EH[ł"));

		if(!silent)
			AfxMessageBox(_T("04WebServerpł悤ɁAWindowst@CA[EH[ݒ肵܂B"), MB_OK | MB_ICONINFORMATION);
	}
	catch(CAddAuthorizedAppException err)
	{
		if(!silent)
			AfxMessageBox(err.m_errorInfo, MB_OK | MB_ICONEXCLAMATION);
		TRACE(_T("%s\n"),err.m_errorInfo);
	}
}

/*!
	폜
*/
void CICF::DelApp(int silent)
{
	try
	{
		if(CAddAuthorizedApp2::CanUse())
			CAddAuthorizedApp2::DelAppFromFW(_T(SERVER_NAME));
		else if(CAddAuthorizedApp::CanUse())
		{
			CAddAuthorizedApp::DelAppFromFW(CPathTools::GetAppPath() + _T(SERVER_FILE_NAME));
			CAddAuthorizedApp::DelAppFromFW(CPathTools::GetAppPath() + _T(SERVER_FILE_NAME_SERVICE));
		}
		else
			throw CAddAuthorizedAppException(_T("Windowst@CA[EH[ł"));

		if(!silent)
			AfxMessageBox(_T("Windowst@CA[EH[̐ݒ܂B"), MB_OK | MB_ICONINFORMATION);
	}
	catch(CAddAuthorizedAppException err)
	{
		if(!silent)
			AfxMessageBox(err.m_errorInfo, MB_OK | MB_ICONEXCLAMATION);
		TRACE(_T("%s\n"),err.m_errorInfo);
	}
}
