#include "StdAfx.h"
#include "AddAuthorizedApp.h"
#pragma comment(lib,"comsuppw.lib")



///////////////////////////////////////////////////////////////////////////////////////////////////
//	J\bh
///////////////////////////////////////////////////////////////////////////////////////////////////
/*!
	Oǉ
*/
void CAddAuthorizedApp::AddAppToFW(CString appName, CString appPath)
{
	//	܂͍폜
	DelAppFromFW(appPath);

	//	INetFwMgr𐶐
	CComPtr<INetFwMgr>	netFwMgr;
	HRESULT hResult = ::CoCreateInstance((REFCLSID)CLSID_NetFwMgr, 0, CLSCTX_INPROC_SERVER, (REFIID)IID_INetFwMgr, (LPVOID*)&netFwMgr);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwMgr擾ł܂"));

	//	|V[擾
	CComPtr<INetFwPolicy>	localPolicy;
	hResult = netFwMgr->get_LocalPolicy(&localPolicy);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwPolicy擾ł܂"));

	//	vt@C擾
	CComPtr<INetFwProfile>	netFwProfile;
	hResult = localPolicy->get_CurrentProfile(&netFwProfile);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwProfile擾ł܂"));

	//	NetFwAuthorizedApplications 擾
	CComPtr<INetFwAuthorizedApplications>	netAuthApps;
	hResult = netFwProfile->get_AuthorizedApplications(&netAuthApps);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwAuthorizedApplications擾ł܂"));
		
	//	INetFwAuthorizedApplication𐶐
	CComPtr<INetFwAuthorizedApplication>	netAuthApp;
	hResult = ::CoCreateInstance((REFCLSID)CLSID_NetFwAuthorizedApplication, 0, CLSCTX_INPROC_SERVER, (REFIID)IID_INetFwAuthorizedApplication, (LPVOID*)&netAuthApp);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwAuthorizedApplication擾ł܂"));
	
	//	p^ݒ
	hResult = netAuthApp->put_Name(_bstr_t(appName));
	if(!SUCCEEDED(hResult))
		ThrowException(_T("[̒ǉɎs܂"));
	hResult = netAuthApp->put_ProcessImageFileName(_bstr_t(appPath));
	if(!SUCCEEDED(hResult))
		ThrowException(_T("[̒ǉɎs܂"));

	//	ǉ
	hResult = netAuthApps->Add(netAuthApp);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("[̒ǉɎs܂"));
	TRACE(_T("[ǉ܂\n"));
}

/*!
	O폜
*/
void CAddAuthorizedApp::DelAppFromFW(CString appPath)
{
	//	INetFwMgr𐶐
	CComPtr<INetFwMgr>	netFwMgr;
	HRESULT hResult = ::CoCreateInstance((REFCLSID)CLSID_NetFwMgr, 0, CLSCTX_INPROC_SERVER, (REFIID)IID_INetFwMgr, (LPVOID*)&netFwMgr);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwMgr擾ł܂"));

	//	|V[擾
	CComPtr<INetFwPolicy>	localPolicy;
	hResult = netFwMgr->get_LocalPolicy(&localPolicy);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwPolicy擾ł܂"));

	//	vt@C擾
	CComPtr<INetFwProfile>	netFwProfile;
	hResult = localPolicy->get_CurrentProfile(&netFwProfile);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwProfile擾ł܂"));

	//	NetFwAuthorizedApplications 擾
	CComPtr<INetFwAuthorizedApplications>	netAuthApps;
	hResult = netFwProfile->get_AuthorizedApplications(&netAuthApps);
	if(!SUCCEEDED(hResult))
		ThrowException(_T("INetFwAuthorizedApplications擾ł܂"));

	//	݂mF
	CComPtr<INetFwAuthorizedApplication>	netAuthApp;
	hResult = netAuthApps->Item(_bstr_t(appPath), &netAuthApp);
	if(SUCCEEDED(hResult))
	{
		//	폜
		hResult = netAuthApps->Remove(_bstr_t(appPath));
		if(!SUCCEEDED(hResult))
			ThrowException(_T("[̍폜Ɏs܂"));
		TRACE(_T("[폜܂\n"));
	}
	else if(hResult != HRESULT_FROM_WIN32(ERROR_FILE_NOT_FOUND))
		ThrowException(_T("[̍폜Ɏs܂"));
}

/*!
	INetFwMgrg邩`FbN
*/
bool CAddAuthorizedApp::CanUse()
{
	CComPtr<INetFwMgr>	netFwMgr;
	HRESULT hResult = ::CoCreateInstance((REFCLSID)CLSID_NetFwMgr, 0, CLSCTX_INPROC_SERVER, (REFIID)IID_INetFwMgr, (LPVOID*)&netFwMgr);
	if(!SUCCEEDED(hResult))
	{
		TRACE("Can not use INetFwMgr\n");
		return FALSE;
	}

	TRACE("Can use INetFwMgr\n");
	return TRUE;
}



/*!
	G[𓊂
*/
void CAddAuthorizedApp::ThrowException(CString errorInfo)
{
	TRACE(_T("Error : %s\n"), errorInfo);
	throw CAddAuthorizedAppException(errorInfo);
}
