#include "StdAfx.h"
#include "connectinfoview.h"
#include "ServerController.h"

CConnectInfoView::CConnectInfoView(void)
{
	m_viewThreadName = "Thread_";
}

CConnectInfoView::~CConnectInfoView(void)
{
}
BEGIN_MESSAGE_MAP(CConnectInfoView, CMainViewBase)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_PAINT()
	ON_WM_TIMER()
	ON_NOTIFY(NM_CLICK, 1024, OnNMClickList)
	ON_NOTIFY(NM_DBLCLK, 1024, OnNMClickList)
END_MESSAGE_MAP()

int CConnectInfoView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMainViewBase::OnCreate(lpCreateStruct) == -1)
		return -1;

	m_list.Create(WS_CHILD | WS_VISIBLE | LVS_REPORT | LVS_NOSORTHEADER | WS_BORDER | LVS_SHOWSELALWAYS,CRect(0,0,100,100),this,1024);

	//	C[WXg̏
	m_imageList.Create(16,16,ILC_COLOR8|ILC_MASK,1,1);
	m_imageList.SetBkColor(::GetSysColor(COLOR_WINDOW));
	m_imageList.Add(GET_APP()->LoadIcon(IDI_TRANS));
	m_imageList.Add(GET_APP()->LoadIcon(IDI_CHECK));

	m_list.SetImageList(&m_imageList,LVSIL_SMALL);
	m_list.InsertColumn(0,_T("Host"),LVCFMT_LEFT,105);
	m_list.InsertColumn(1,_T("Time"),LVCFMT_LEFT,60);
	m_list.InsertColumn(2,_T("Method"),LVCFMT_LEFT,60);
	m_list.InsertColumn(3,_T("ResponseText"),LVCFMT_LEFT,100);
	m_list.InsertColumn(4,_T("Info"),LVCFMT_LEFT,300);
	m_list.InsertColumn(5,_T("URL"),LVCFMT_LEFT,600);
	m_list.SetExtendedStyle(LVS_EX_FULLROWSELECT);

	m_contextCurrent = m_context.GetAccess("Threads");
	m_contextLog = m_context.GetAccess("ThreadLogs");
	m_viewAccess = m_view.GetAccess("ThreadView");

	SetTimer(1024,1000,NULL);
	UpdateList();
	return 0;
}

void CConnectInfoView::OnSize(UINT nType, int cx, int cy)
{
	CMainViewBase::OnSize(nType, cx, cy);

	m_list.MoveWindow(0,200,cx - LINE_PADDING,cy - LINE_PADDING - 200);
}

void CConnectInfoView::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	DrawInfo(&dc);
}

//	`
void CConnectInfoView::DrawInfo(CDC *dc)
{
	CRect	client;
	GetClientRect(client);

	if(FindNode(m_contextCurrent,m_viewThreadName))
		m_viewAccess.Copy(m_contextCurrent.GetAccess(m_viewThreadName));

	if(FindNode(m_contextLog,m_viewThreadName))
		m_viewAccess.Copy(m_contextLog.GetAccess(m_viewThreadName));

	if(m_viewAccess.GetConfig("ThreadName","").IsEmpty())
	{
		DrawText(dc,2,10,400,"Xg̍ڂNbNƁAɏڍׂ\܂B","");
		SetInfoActive(FALSE);
	}
	else
	{
		SetInfoActive(TRUE);

		if(!m_viewAccess.GetConfig("RequestInfo::Object","").IsEmpty())
			DrawText(dc,2,10,client.Width(),"URL",m_viewAccess.GetConfig("Protocol","http") + "://" + m_viewAccess.GetConfig("RequestInfo::Options::Host","-s-",TRUE) + m_viewAccess.GetConfig("RequestInfo::Object",""));
		else
			DrawText(dc,2,10,client.Width(),"URL","");

		DrawText(dc,2,40,client.Width(),"Info",m_viewAccess.GetConfig("Info",""));

		DrawText(dc,2,80,150,"Host",m_viewAccess.GetConfig("Host",""));
		DrawText(dc,2,110,150,"Method",m_viewAccess.GetConfig("RequestInfo::Method",""));
		DrawText(dc,2,140,150,"ResponseText",m_viewAccess.GetConfig("ResponseInfo::ResponseText",""));

		DrawText(dc,152,80,150,"StartTime",m_viewAccess.GetConfig("StartTime::Date","") + " " + m_viewAccess.GetConfig("StartTime::Time",""));
		DrawText(dc,152,110,150,"EndTime",m_viewAccess.GetConfig("EndTime::Date","") + " " + m_viewAccess.GetConfig("EndTime::Time",""));
		DrawText(dc,152,140,150,"User",m_viewAccess.GetConfig("RequestInfo::User",""));

		DrawText(dc,302,80,client.Width() - 302,"User-Agent",m_viewAccess.GetConfig("RequestInfo::Options::User-Agent","",TRUE));
		DrawText(dc,302,110,client.Width() - 302,"Referer",m_viewAccess.GetConfig("RequestInfo::Options::Referer","",TRUE));

		__int64 send = _atoi64(m_viewAccess.GetConfig("SendSize","0"));
		__int64 recv = _atoi64(m_viewAccess.GetConfig("RecvSize","0"));
		CString	str;
		if(send || recv)
			str.Format("Recv : %I64d / Send : %I64d",recv,send);

		DrawText(dc,302,140,client.Width() - 302,"RecvSize/SendSize", str);
	}
}

//	eLXgo
void CConnectInfoView::DrawText(CDC *dc,int x,int y,int width,CString label,CString text,int alert)
{
	CRect	rect(x,y,x + width,y + 16);

	CFontSelector bold(dc,GET_GDI().m_fBold);
	dc->SetTextColor(TEXT_COLOR_BLUE);
	dc->FillSolidRect(rect,TEXT_COLOR_WHITE);
	dc->DrawText(label,rect,DT_WORD_ELLIPSIS);

	CFontSelector normal(dc,GET_GDI().m_fNormal);
	if(alert)
		dc->SetTextColor(TEXT_COLOR_RED);
	else
		dc->SetTextColor(TEXT_COLOR_BLACK);

	rect.SetRect(x + 14, y + 14, x + width, y + 30);
	dc->FillSolidRect(rect,TEXT_COLOR_WHITE);
	dc->DrawText(text,rect,DT_PATH_ELLIPSIS);
}

//	Xg
void CConnectInfoView::UpdateList()
{
	CString	context = GET_APP()->m_serverControl.GetServerContext();
	m_context.FromString(context);


	//	s
	CStringArray	list;
	m_contextCurrent.GetAllSubNode(list);
	int	oldCount = m_list.GetItemCount();
	for(int i=0;i<list.GetSize();i++)
	{
		CConfigAccess thread = m_contextCurrent.GetAccess(list[list.GetSize() - i - 1]);
		if(i >= oldCount)
			m_list.InsertItem(i,thread.GetConfig("Host",""),0);
		else
			m_list.SetItem(i,0,LVIF_IMAGE,NULL,0,0,0,NULL);

		m_list.SetItemText(i,0,thread.GetConfig("Host",""));
		m_list.SetItemText(i,1,thread.GetConfig("StartTime::Time",""));
		m_list.SetItemText(i,2,thread.GetConfig("RequestInfo::Method",""));
		m_list.SetItemText(i,3,thread.GetConfig("ResponseInfo::ResponseText",""));
		m_list.SetItemText(i,4,thread.GetConfig("Info",""));

		if(!thread.GetConfig("RequestInfo::Object","").IsEmpty())
			m_list.SetItemText(i,5,m_viewAccess.GetConfig("Protocol","http") + "://" + thread.GetConfig("RequestInfo::Options::Host","-s-",TRUE) + thread.GetConfig("RequestInfo::Object",""));
		else
			m_list.SetItemText(i,5,"");
	}

	//	I
	int cur = (int)list.GetSize();
	m_contextLog.GetAllSubNode(list);
	for(i=0;i<list.GetSize();i++)
	{
		int j = i + cur;
		CConfigAccess thread = m_contextLog.GetAccess(list[list.GetSize() - i - 1]);
		if(j >= oldCount)
			m_list.InsertItem(j,thread.GetConfig("Host",""),1);
		else
			m_list.SetItem(j,0,LVIF_IMAGE,NULL,1,0,0,NULL);

		m_list.SetItemText(j,0,thread.GetConfig("Host",""));
		m_list.SetItemText(j,1,thread.GetConfig("StartTime::Time",""));
		m_list.SetItemText(j,2,thread.GetConfig("RequestInfo::Method",""));
		m_list.SetItemText(j,3,thread.GetConfig("ResponseInfo::ResponseText",""));
		m_list.SetItemText(j,4,thread.GetConfig("Info",""));

		if(!thread.GetConfig("RequestInfo::Object","").IsEmpty())
			m_list.SetItemText(j,5,m_viewAccess.GetConfig("Protocol","http") + "://" + thread.GetConfig("RequestInfo::Options::Host","-s-",TRUE) + thread.GetConfig("RequestInfo::Object",""));
		else
			m_list.SetItemText(j,5,"");
	}

	for(i=cur+(int)list.GetSize();i<oldCount;i++)
		m_list.DeleteItem(i);

}

void CConnectInfoView::OnTimer(UINT nIDEvent)
{
	//	ŏ͍XVȂ
	if(!AfxGetApp()->GetMainWnd()->IsIconic())
	{
		CClientDC 	dc(this);

		DrawInfo(&dc);
		UpdateList();
	}

	CMainViewBase::OnTimer(nIDEvent);
}

void CConnectInfoView::OnNMClickList(NMHDR *pNMHDR, LRESULT *pResult)
{
	int index = GetSelectItem();
	if(index != -1)
	{
		CStringArray	list;
		m_contextCurrent.GetAllSubNode(list);

		if(index < list.GetSize())
		{
			m_viewThreadName = list[list.GetSize() - index - 1];
		}
		else
		{
			index -= (int)list.GetSize();
			m_contextLog.GetAllSubNode(list);

			if(index <list.GetSize())
			{
				m_viewThreadName = list[list.GetSize() - index - 1];
			}
		}

		CClientDC 	dc(this);
		DrawInfo(&dc);
	}
	*pResult = 0;
}

//	I𒆂̃ACe擾
int CConnectInfoView::GetSelectItem()
{
	int	i,len = m_list.GetItemCount();
	for(i=0;i<len;i++)
	{
		if(m_list.GetItemState(i, LVIS_SELECTED)==LVIS_SELECTED)
		{
			return(i);
		}
	}

	return(-1);
}


//	m[ȟ
int CConnectInfoView::FindNode(CConfigAccess access,CString node)
{
	CStringArray	list;
	access.GetAllSubNode(list);

	for(int i=0;i<list.GetSize();i++)
		if(list[i] == node)
			return(1);
	return(0);
}

//	
CString CConnectInfoView::ToString()
{
	CString	text;

	if(!m_viewAccess.GetConfig("RequestInfo::Object","").IsEmpty())
		text += GetFormatText("URL","http://" + m_viewAccess.GetConfig("RequestInfo::Options::Host","-s-",TRUE) + m_viewAccess.GetConfig("RequestInfo::Object",""));
	else
		text += GetFormatText("URL","");

	text += GetFormatText("Info",m_viewAccess.GetConfig("Info",""));

	text += GetFormatText("Host",m_viewAccess.GetConfig("Host",""));
	text += GetFormatText("Method",m_viewAccess.GetConfig("RequestInfo::Method",""));
	text += GetFormatText("ResponseText",m_viewAccess.GetConfig("ResponseInfo::ResponseText",""));

	text += GetFormatText("StartTime",m_viewAccess.GetConfig("StartTime::Date","") + " " + m_viewAccess.GetConfig("StartTime::Time",""));
	text += GetFormatText("EndTime",m_viewAccess.GetConfig("EndTime::Date","") + " " + m_viewAccess.GetConfig("EndTime::Time",""));
	text += GetFormatText("User",m_viewAccess.GetConfig("RequestInfo::User",""));

	text += GetFormatText("User-Agent",m_viewAccess.GetConfig("RequestInfo::Options::User-Agent","",TRUE));
	text += GetFormatText("Referer",m_viewAccess.GetConfig("RequestInfo::Options::Referer","",TRUE));

	__int64 send = _atoi64(m_viewAccess.GetConfig("SendSize","0"));
	__int64 recv = _atoi64(m_viewAccess.GetConfig("RecvSize","0"));
	CString	str;
	if(send || recv)
		str.Format("Recv : %I64d / Send : %I64d",recv,send);

	text += GetFormatText("RecvSize/SendSize", str);

	return(text);
}

//	蔲p
CString CConnectInfoView::GetFormatText(CString label,CString text)
{
	return(label + "\r\n@" + text + "\r\n\r\n");
}


