#pragma once
#include "mainviewbase.h"
#include "config.h"

class CConnectInfoView :
	public CMainViewBase
{
public:
	CConnectInfoView(void);
	virtual ~CConnectInfoView(void);

	virtual CString ToString();

	CListCtrl		m_list;
	CImageList		m_imageList;
	CConfig			m_context;
	CConfigAccess	m_contextCurrent;
	CConfigAccess	m_contextLog;
	CConfig			m_view;
	CConfigAccess	m_viewAccess;
	CString			m_viewThreadName;

	int FindNode(CConfigAccess access,CString node);

	void DrawText(CDC *dc,int x,int y,int width,CString label,CString text,int alert=0);
	void UpdateList();
	int GetSelectItem();
	void DrawInfo(CDC *dc);
	CString GetFormatText(CString label,CString text);

	DECLARE_MESSAGE_MAP()
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnPaint();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnNMClickList(NMHDR *pNMHDR, LRESULT *pResult);
};
