// HeadderView.cpp : t@C
//

#include "stdafx.h"
#include "HeadderView.h"
#include "ServerController.h"


// CHeadderView

IMPLEMENT_DYNAMIC(CHeadderView, CWnd)
CHeadderView::CHeadderView()
{
}

CHeadderView::~CHeadderView()
{
}


BEGIN_MESSAGE_MAP(CHeadderView, CWnd)
	ON_WM_PAINT()
END_MESSAGE_MAP()

void CHeadderView::SetLabel(CString label,CString info)
{
	m_label = label;
	m_info = info;

	if(::IsWindow(m_hWnd))
		Invalidate();
}


void CHeadderView::OnPaint()
{
	CPaintDC dc(this); // device context for painting

	CFontSelector large(&dc,GET_GDI().m_fLarge);

	dc.SetBkMode(TRANSPARENT);
	dc.SetTextColor(TEXT_COLOR_BLUE);
	dc.TextOut(2,8,m_label);

	CFontSelector normal(&dc,GET_GDI().m_fNormal);
	dc.SetTextColor(TEXT_COLOR_BLACK);
	dc.TextOut(2,40,m_info);

	CRect	client;
	GetClientRect(client);

	CPenSelector	gray(&dc,GET_GDI().m_pGray);
	dc.MoveTo(0,client.bottom - LINE_PADDING - 1);
	dc.LineTo(client.right - LINE_PADDING,client.bottom - LINE_PADDING - 1);

	CPenSelector	light(&dc,GET_GDI().m_pLight);
	dc.MoveTo(0,client.bottom - LINE_PADDING);
	dc.LineTo(client.right - LINE_PADDING,client.bottom - LINE_PADDING);
}

BOOL CHeadderView::PreCreateWindow(CREATESTRUCT& cs)
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), GET_GDI().m_bWhite, NULL);

	return TRUE;
}
