// KeyGenDialog.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "KeyGenDialog.h"
#include "opensslutil.h"


// CKeyGenDialog _CAO

IMPLEMENT_DYNAMIC(CKeyGenDialog, CDialog)
CKeyGenDialog::CKeyGenDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CKeyGenDialog::IDD, pParent)
	, m_keyPath(_T(""))
	, m_pass1(_T(""))
	, m_pass2(_T(""))
	, m_caPath(_T(""))
	, m_c(_T(""))
	, m_st(_T(""))
	, m_l(_T(""))
	, m_o(_T(""))
	, m_ou(_T(""))
	, m_cn(_T(""))
	, m_mail(_T(""))
	, m_before(0)
	, m_after(365*10)
	, m_enableCSR(FALSE)
	, m_csrPath(_T(""))
{
}

CKeyGenDialog::~CKeyGenDialog()
{
}

void CKeyGenDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_KEY_PATH, m_keyPath);
	DDX_Text(pDX, IDC_PASS1, m_pass1);
	DDX_Text(pDX, IDC_PASS2, m_pass2);
	DDX_Text(pDX, IDC_CA_PATH, m_caPath);
	DDX_Text(pDX, IDC_C, m_c);
	DDX_Text(pDX, IDC_ST, m_st);
	DDX_Text(pDX, IDC_L, m_l);
	DDX_Text(pDX, IDC_O, m_o);
	DDX_Text(pDX, IDC_OU, m_ou);
	DDX_Text(pDX, IDC_CN, m_cn);
	DDX_Text(pDX, IDC_MAIL, m_mail);
	DDX_Text(pDX, IDC_BEFORE, m_before);
	DDX_Text(pDX, IDC_AFTER, m_after);
	DDX_Check(pDX, IDC_ENABLE_CSR, m_enableCSR);
	DDX_Text(pDX, IDC_CSR_PATH, m_csrPath);
}


BEGIN_MESSAGE_MAP(CKeyGenDialog, CDialog)
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
	ON_BN_CLICKED(IDC_KEY_BR, OnBnClickedKeyBr)
	ON_BN_CLICKED(IDC_CA_BR, OnBnClickedCaBr)
	ON_BN_CLICKED(IDC_CSR_BR, OnBnClickedCsrBr)
END_MESSAGE_MAP()


// CKeyGenDialog bZ[W nh

void CKeyGenDialog::OnBnClickedOk()
{
	UpdateData(TRUE);

	//	pX[h
	if(m_pass1.IsEmpty() || m_pass1 != m_pass2)
	{
		MessageBox("pX[hvȂA󗓂łB","04WebServer",MB_ICONEXCLAMATION | MB_OK);
		return;
	}

	//	
	if(m_c.GetLength() != 2)
	{
		MessageBox("2łB","04WebServer",MB_ICONEXCLAMATION | MB_OK);
		return;
	}

	//	L[
	COpenSSLUtil	util;
	util.SetPassword(m_pass1);
	if(util.GeneratePrivateKey())
	{
		MessageBox("RSA閧̐Ɏs܂B","04WebServer",MB_ICONEXCLAMATION | MB_OK);
		return;
	}

	//	L[̕ۑ
	if(util.SavePrivateKey(m_keyPath))
	{
		MessageBox("RSA閧̐Ɏs܂B","04WebServer",MB_ICONEXCLAMATION | MB_OK);
		return;
	}

	//	ݒ
	COpenSSLUtil::CX509Entry	entry;

	entry.m_serialNumber = 0;
	entry.m_notBeforeDays = m_before * 24 * 60 * 60;
	entry.m_notAfterDays = m_after * 24 * 60 * 60;

	entry.m_countryName = m_c;
	entry.m_statName = m_st;
	entry.m_localityName = m_l;
	entry.m_organizationName = m_o;
	entry.m_organizationalUnitName = m_ou;
	entry.m_commonName = m_cn;
	entry.m_email = m_mail;

	if(m_enableCSR)
	{
		//	Fؗvt@C̕ۑ
		if(util.SaveCSR(m_csrPath,entry))
		{
			MessageBox("Fؗvt@C̐Ɏs܂B","04WebServer",MB_ICONEXCLAMATION | MB_OK);
			return;
		}
	}

	//	TCgؖt@C̕ۑ
	if(util.SaveCRT(m_caPath,entry))
	{
		MessageBox("Fؗvt@C̐Ɏs܂B","04WebServer",MB_ICONEXCLAMATION | MB_OK);
		return;
	}

	MessageBox("閧ƃTCgؖ̐ɐ܂B","04WebServer",MB_ICONINFORMATION | MB_OK);
	OnOK();
}

void CKeyGenDialog::OnBnClickedKeyBr()
{
	UpdateData(TRUE);
	
	CFileDialog	sel(FALSE,"pem","04WebServer.pem");
	if(sel.DoModal()==IDOK)
		m_keyPath = sel.GetPathName();

	UpdateData(FALSE);
}

void CKeyGenDialog::OnBnClickedCaBr()
{
	UpdateData(TRUE);

	CFileDialog	sel(FALSE,"crt","04WebServer.crt");
	if(sel.DoModal()==IDOK)
		m_caPath = sel.GetPathName();

	UpdateData(FALSE);
}

void CKeyGenDialog::OnBnClickedCsrBr()
{
	UpdateData(TRUE);

	CFileDialog	sel(FALSE,"pem","CSR.pem");
	if(sel.DoModal()==IDOK)
		m_csrPath = sel.GetPathName();

	UpdateData(FALSE);
}

BOOL CKeyGenDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_keyPath = GET_APP()->m_serverControl.GetServerRoot() + "SSLKey\\04WebServer.pem";
	m_caPath = GET_APP()->m_serverControl.GetServerRoot() + "SSLKey\\04WebServer.crt";
	m_csrPath = GET_APP()->m_serverControl.GetServerRoot() + "SSLKey\\CSR.pem";
	m_c = "JP";

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}
