// ServerPage2.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "ServerPage2.h"


// CServerPage2 _CAO

IMPLEMENT_DYNAMIC(CServerPage2, CPropertyPage)
CServerPage2::CServerPage2()
	: CPropertyPage(CServerPage2::IDD)
	, m_addName(_T(""))
{
}

CServerPage2::~CServerPage2()
{
}

void CServerPage2::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_INDEX, m_index);
	DDX_Text(pDX, IDC_EDIT1, m_addName);
}


BEGIN_MESSAGE_MAP(CServerPage2, CPropertyPage)
	ON_BN_CLICKED(IDC_ADD, OnBnClickedAdd)
	ON_BN_CLICKED(IDC_DEL, OnBnClickedDel)
	ON_BN_CLICKED(IDC_UP, OnBnClickedUp)
	ON_BN_CLICKED(IDC_UP2, OnBnClickedUp2)
END_MESSAGE_MAP()


// CServerPage2 bZ[W nh

void CServerPage2::OnBnClickedAdd()
{
	UpdateData();
	if(m_addName.IsEmpty())
	{
		MessageBox("O͂Ă܂B");
		return;
	}

	CStringListCtrl::CListItem	add;

	add.m_text = m_addName;
	m_index.Add(add);

	m_index.UpdateList(FALSE);
}

void CServerPage2::OnBnClickedDel()
{
	m_index.DeleteSelectedItem();
	m_index.UpdateList(FALSE);
}

BOOL CServerPage2::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	//	C[WXg̏
	m_imageList.Create(16,16,ILC_COLOR8|ILC_MASK,1,1);
	m_imageList.SetBkColor(::GetSysColor(COLOR_WINDOW));
	m_imageList.Add(GET_APP()->LoadIcon(IDI_IE));

	CRect	r;
	m_index.GetClientRect(r);
	m_index.SetImageList(&m_imageList,LVSIL_SMALL);
	m_index.InsertColumn(0,_T("t@C"),LVCFMT_LEFT,r.Width()-1);


	CConfigAccess index = GET_APP()->m_setting.GetAccess("Index");
	CStringArray	list;
	index.GetAllKey(list);
	for(int i=0;i<list.GetSize();i++)
	{
		CStringListCtrl::CListItem	add;

		add.m_text = index.GetConfig(list[i],"");
		m_index.Add(add);
	}

	m_index.UpdateList(FALSE);

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

BOOL CServerPage2::OnKillActive()
{
	//	o
	GET_APP()->m_setting.DeleteNode("Index");
	CConfigAccess index = GET_APP()->m_setting.GetAccess("Index");

	int	i,len = (int)m_index.GetSize();
	for(i=0;i<len;i++)
	{
		index.SetConfig(m_index[i].m_text,m_index[i].m_text);
	}

	UpdateData(TRUE);

	return CPropertyPage::OnKillActive();
}

void CServerPage2::OnBnClickedUp()
{
	int index = m_index.GetFirstSelect();
	if(index > 0)
	{
		CStringListCtrl::CListItem	swap = m_index[index];
		m_index[index] = m_index[index-1];
		m_index[index-1] = swap;
		m_index.UpdateList(FALSE);
		m_index.SelectItem(index-1);
	}
	else
		MessageBeep(MB_OK);
}

void CServerPage2::OnBnClickedUp2()
{
	int index = m_index.GetFirstSelect();
	if(index != -1 && index < m_index.GetSize() - 1)
	{
		CStringListCtrl::CListItem	swap = m_index[index];
		m_index[index] = m_index[index+1];
		m_index[index+1] = swap;
		m_index.UpdateList(FALSE);
		m_index.SelectItem(index+1);
	}
	else
		MessageBeep(MB_OK);
}

