// UserImportDialog.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "UserImportDialog.h"
#include "FileSelectDialog.h"


// CUserImportDialog _CAO

IMPLEMENT_DYNAMIC(CUserImportDialog, CDialog)
CUserImportDialog::CUserImportDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CUserImportDialog::IDD, pParent)
{
}

CUserImportDialog::~CUserImportDialog()
{
}

void CUserImportDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_USER, m_user);
}


BEGIN_MESSAGE_MAP(CUserImportDialog, CDialog)
	ON_BN_CLICKED(IDC_OPEN, OnBnClickedOpen)
END_MESSAGE_MAP()


// CUserImportDialog bZ[W nh

void CUserImportDialog::OnBnClickedOpen()
{
	CFileSelectDialog	sel(m_hWnd);
	sel.AddExt("*.csv","CSVt@C (*.csv)");
	sel.AddExt("*.txt","eLXgt@C (*.txt)");

	if(sel.OpenFile() == IDOK)
		ParseItem(sel.GetFilePath());
}

BOOL CUserImportDialog::OnInitDialog()
{
	CDialog::OnInitDialog();


	//	C[WXg̏
	m_imageList.Create(16,16,ILC_COLOR8|ILC_MASK,1,1);
	m_imageList.SetBkColor(::GetSysColor(COLOR_WINDOW));
	m_imageList.Add(GET_APP()->LoadIcon(IDI_USER2));

	CRect	r;
	m_user.GetClientRect(r);
	m_user.SetImageList(&m_imageList,LVSIL_SMALL);
	m_user.InsertColumn(0,_T("[U["),LVCFMT_LEFT,100);
	m_user.InsertColumn(1,_T("pX[h"),LVCFMT_LEFT,100);
	m_user.InsertColumn(2,_T("Rg"),LVCFMT_LEFT,r.Width() - 200);
	m_user.SetExtendedStyle(LVS_EX_FULLROWSELECT);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}


//!
void CUserImportDialog::ParseItem(CString path)
{
	FILE *in = _tfopen(path,_T("rt"));
	

	m_user.ClearAll();
	while(1)
	{
		CString	line = Fgets(in);
		if(feof(in))
			break;

		TRACE(_T("line : %s\n"),line);

		CString	user = GetToken(line);
		CString	passwd = GetToken(line);
		CString	comment = GetToken(line);

		if(!user.IsEmpty() && !passwd.IsEmpty())
		{
			CStringListCtrl::CListItem	add;
			add.m_text = user;
			add.m_subText.Add(passwd);
			add.m_subText.Add(comment);
			m_user.Add(add);
		}
	}

	m_user.UpdateList();
	fclose(in);
}

//!	CStringfgets
CString CUserImportDialog::Fgets(FILE *in)
{
	CString	ret;

	fgets(ret.GetBuffer(1024),1023,in);
	ret.ReleaseBuffer();
	ret.TrimLeft();
	ret.TrimRight();

	return(ret);
}

//!	؂o
CString CUserImportDialog::GetToken(CString &line)
{
	int	index;

	index = line.Find(_T(","));
	if(index == -1)
		index = line.Find(_T("	"));

	if(index == -1)
	{
		CString ret = line;
		line.Empty();

		ret.TrimLeft();
		ret.TrimRight();
		return(ret);
	}

	CString ret = line.Left(index);
	line = line.Mid(index + 1);

	ret.TrimLeft();
	ret.TrimRight();

	return(ret);
}

