#include "StdAfx.h"
#include "configaccess.h"
#include "config.h"

CConfigAccess::CConfigAccess()
{
	m_path = "";
	m_root = NULL;
}

CConfigAccess::CConfigAccess(CConfig *root,CString path)
{
	if(path.GetLength() >= 2)
	{
		if(path.Right(2) != "::")
			path += "::";
	}
	else
		path += "::";

	m_path = path;
	m_root = root;
}

CConfigAccess::~CConfigAccess(void)
{
}


/*!
 *	f[^̐ݒ
 *
 *	@param key	L[
 *	@param data	ݒ肷f[^
 */
void CConfigAccess::SetConfig(CString key, CString data)
{
	ASSERT(m_root != NULL);

	m_root->SetConfig(m_path + key,data);
}

/*!
 *	f[^̐ݒ
 *
 *	@param key	L[
 *	@param data	ݒ肷f[^
 */
void CConfigAccess::SetConfig(CString key, int data)
{
	ASSERT(m_root != NULL);

	char	buf[80];

	m_root->SetConfig(m_path + key,itoa(data,buf,10));
}


/*!
 *	f[^̐ݒ
 *
 *	@param key	L[
 *	@param data	ݒ肷f[^
 */
void CConfigAccess::SetConfig(CString key, UINT data)
{
	ASSERT(m_root != NULL);

	char	buf[80];

	m_root->SetConfig(m_path + key,_ui64toa(data,buf,10));
}


/*!
 *	f[^̐ݒ
 *
 *	@param key	L[
 *	@param data	ݒ肷f[^
 */
void CConfigAccess::SetConfig(CString key, __int64 data)
{
	ASSERT(m_root != NULL);

	char	buf[80];

	m_root->SetConfig(m_path + key,_i64toa(data,buf,10));
}


/*!
 *	f[^̎擾
 *
 *	@param key			L[
 *	@param noCase		啶̋
 *	@param defaultData	ftHg
 */
CString CConfigAccess::GetConfig(CString key, CString defaultData,int noCase)
{
	ASSERT(m_root != NULL);

	return(m_root->GetConfig(m_path + key,defaultData,noCase));
}

/*!
 *	f[^̎擾
 *
 *	@param key			L[
 *	@param noCase		啶̋
 *	@param defaultData	ftHg
 */
int CConfigAccess::GetConfig(CString key, int defaultData,int noCase)
{
	ASSERT(m_root != NULL);

	char	buf[40];
	CString ret = m_root->GetConfig(m_path + key,itoa(defaultData,buf,10),noCase);
	return(atoi(ret));
}

/*!
 *	f[^̎擾
 *
 *	@param key			L[
 *	@param noCase		啶̋
 *	@param defaultData	ftHg
 */
UINT CConfigAccess::GetConfig(CString key, UINT defaultData,int noCase)
{
	ASSERT(m_root != NULL);

	char	buf[40];
	CString ret = m_root->GetConfig(m_path + key,_ui64toa(defaultData,buf,10),noCase);
	return(atoi(ret));
}

/*!
 *	f[^̎擾
 *
 *	@param key			L[
 *	@param noCase		啶̋
 *	@param defaultData	ftHg
 */
__int64 CConfigAccess::GetConfig(CString key, __int64 defaultData,int noCase)
{
	ASSERT(m_root != NULL);

	char	buf[80];
	CString ret = m_root->GetConfig(m_path + key,_i64toa(defaultData,buf,10),noCase);
	return(atoi(ret));
}


/*!
 *	SẴL[擾
 *
 *	@param list	L[Xg
 *	@return		L[
 */
int CConfigAccess::GetAllKey(CStringArray &list)
{
	ASSERT(m_root != NULL);

	return(m_root->GetAllKey(m_path,list));
}


/*!
 *	SẴTum[h擾
 *
 *	@param list	m[hXg
 *	@return		m[h
 */
int CConfigAccess::GetAllSubNode(CStringArray &list)
{
	ASSERT(m_root != NULL);

	return(m_root->GetAllSubNode(m_path,list));
}

/*!
 *	SẴL[擾
 *
 *	@return		L[
 */
int CConfigAccess::GetKeyCount()
{
	ASSERT(m_root != NULL);

	return(m_root->GetKeyCount(m_path));
}


/*!
 *	SẴTum[h擾
 *
 *	@return		m[h
 */
int CConfigAccess::GetSubNodeCount()
{
	ASSERT(m_root != NULL);

	return(m_root->GetSubNodeCount(m_path));
}


/*!
 *	TuNX̃ANZXNX̎擾
 *
 *	@param subPath	pX
 *	@return			CConfigAccess *
 */
CConfigAccess CConfigAccess::GetAccess(CString subPath)
{
	ASSERT(m_root != NULL);

	return CConfigAccess(m_root,m_path + subPath);
}

/*!
 *	CConfig擾
 *
 *	@return			CConfig *
 */
CConfig * CConfigAccess::GetRoot()
{
	ASSERT(m_root != NULL);

	return(m_root);
}


/*!
 *	NA
 *
 */
void CConfigAccess::Clear()
{
	ASSERT(m_root != NULL);

	m_root->Clear(m_path);
}

/*!
 *	m[h폜
 *
 *	@param name	m[h
 */
void CConfigAccess::DeleteNode(CString name)
{
	ASSERT(m_root != NULL);

	m_root->DeleteNode(m_path + name);
}

/*!
 *	L[폜
 *
 *	@param name	L[
 */
void CConfigAccess::DeleteKey(CString name)
{
	ASSERT(m_root != NULL);

	m_root->DeleteKey(m_path + name);
}

/*!
 *	
 *
 *	@param other	Rs[
 */
void CConfigAccess::Copy(CConfigAccess &other)
{
	ASSERT(m_root != NULL);

	m_root->Copy(m_path,other.m_path,other.m_root);
}

/*!
 *	L[Œu擾
 *
 *	@param str		
 *	@param noData	YȂȕu
 *	@return			
 */
CString CConfigAccess::GetKeySwapString(CString str, CString noData)
{
	ASSERT(m_root != NULL);

	return(m_root->GetKeySwapString(m_path,str,noData));
}
