#include "StdAfx.h"
#include "directoryview.h"
#include "PathPage1.h"
#include "PathPage2.h"
#include "PathPage3.h"
#include "PathPage4.h"

CDirectoryView::CDirectoryView(void)
{
	m_pathSetting = GET_APP()->m_setting.GetAccess("Path");
}

CDirectoryView::~CDirectoryView(void)
{
}

BEGIN_MESSAGE_MAP(CDirectoryView, CMainViewBase)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_MESSAGE( USER_MESG_TOOL_CLICK, OnToolClick )
END_MESSAGE_MAP()

void CDirectoryView::OnPaint()
{
	CPaintDC dc(this); // device context for painting

	CRect	client;
	GetClientRect(client);

	CPenSelector	gray(&dc,GET_GDI().m_pGray);
	dc.MoveTo(0,48);
	dc.LineTo(client.right - LINE_PADDING,48);

	CPenSelector	light(&dc,GET_GDI().m_pLight);
	dc.MoveTo(0,49);
	dc.LineTo(client.right - LINE_PADDING,49);

}

int CDirectoryView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMainViewBase::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_directoryList.Create(NULL, NULL, WS_CHILD | WS_VISIBLE,
		CRect(0, 0, 0, 0), this, 0, NULL))
	{
		TRACE0("r[ EBhE쐬ł܂łB\n");
		return -1;
	}

	if(m_new.Create(this,"VK",IDI_FOLDER2,CPoint(0,0),TOOL_BUTTON_COMMAND_START,1))
		TRACE("Cannot create\n");

	if(m_edit.Create(this,"ҏW",IDI_FOLDER_EDIT,CPoint(90,0),TOOL_BUTTON_COMMAND_START + 1))
		TRACE("Cannot create\n");

	if(m_del.Create(this,"폜",IDI_TRASH,CPoint(180,0),TOOL_BUTTON_COMMAND_START + 2))
		TRACE("Cannot create\n");


	return 0;
}

void CDirectoryView::OnSize(UINT nType, int cx, int cy)
{
	CMainViewBase::OnSize(nType, cx, cy);

	m_directoryList.MoveWindow(0,50,cx,cy-50);
}

//	Iڂ̕ύX
LRESULT CDirectoryView::OnToolClick(WPARAM wParam, LPARAM lParam)
{
	int	sel = (int)wParam - TOOL_BUTTON_COMMAND_START;
	int index = GetFirstSelect();
	CStringArray	list;
	m_pathSetting.GetAllSubNode(list);

	switch(sel)
	{
		case 0:
			NewPath(GetNewPath());
			m_directoryList.UpdateAll();
			break;

		case 1:
			if(index!=-1)
			{
				EditPath(list[index]);
				m_directoryList.Invalidate();
			}
			break;

		case 2:
			if(index!=-1)
			{
				if(MessageBox("폜Ă낵łH","폜",MB_ICONQUESTION | MB_OKCANCEL) == IDOK)
				{
					for(int i=0;i<list.GetSize();i++)
					{
						if(m_pathSetting.GetAccess(list[i]).GetConfig("Selected",0))
						{
							m_pathSetting.DeleteNode(list[i]);
						}
					}
					m_directoryList.UpdateAll();
					GET_APP()->SaveSetting();
				}
			}
			break;
	}

	return(0);
}

//	I擾
int CDirectoryView::GetFirstSelect()
{
	CStringArray	list;
	m_pathSetting.GetAllSubNode(list);

	for(int i=0;i<list.GetSize();i++)
		if(m_pathSetting.GetAccess(list[i]).GetConfig("Selected",0))
			return(i);
	return(-1);
}

//	VK
void CDirectoryView::NewPath(CString pathName)
{
	CConfig			temp;
	CConfigAccess	tempAccess = temp.GetAccess(pathName);

	CPathPage1		page1(tempAccess);
	CPathPage2		page2(tempAccess);
	CPathPage3		page3(tempAccess);
	CPathPage4		page4(tempAccess);
	CPropertySheet	sheet("VKpX",this,0);

	sheet.AddPage(&page1);
	sheet.AddPage(&page2);
	sheet.AddPage(&page3);
	sheet.AddPage(&page4);
	if(sheet.DoModal() == IDOK)
	{
		CConfigAccess	srcAccess = m_pathSetting.GetAccess(pathName);
		srcAccess.Copy(tempAccess);
		GET_APP()->SaveSetting();
	}
}

//	ҏWEVK
void CDirectoryView::EditPath(CString pathName)
{
	CConfig			temp;
	CConfigAccess	tempAccess = temp.GetAccess(pathName);
	CConfigAccess	srcAccess = m_pathSetting.GetAccess(pathName);
	tempAccess.Copy(srcAccess);

	CPathPage1		page1(tempAccess);
	CPathPage2		page2(tempAccess);
	CPathPage3		page3(tempAccess);
	CPathPage4		page4(tempAccess);
	CPropertySheet	sheet("pXҏW",this,0);

	sheet.AddPage(&page1);
	sheet.AddPage(&page2);
	sheet.AddPage(&page3);
	sheet.AddPage(&page4);
	if(sheet.DoModal() == IDOK)
	{
		srcAccess.Copy(tempAccess);
		GET_APP()->SaveSetting();
	}
}

//	VpX̐
CString CDirectoryView::GetNewPath()
{
	CStringArray	list;
	m_pathSetting.GetAllSubNode(list);

	CString newPath;
	int i=0;

	while(1)
	{
		newPath.Format("Path_%d",i++);
		for(int j=0;j<list.GetSize();j++)
			if(list[j] == newPath)
				break;

		if(j == list.GetSize())
			return(newPath);
	}
}


