// IconButton.cpp : t@C
//

#include "stdafx.h"
#include "IconButton.h"
#include "ServerController.h"

#include <Winuser.h>

//	{^̃TCY1
#define	WIDTH		188
#define	HEIGHT	50


// CIconButton
CIconButton::CIconButton()
{
}

CIconButton::~CIconButton()
{
	DestroyWindow();
}


BEGIN_MESSAGE_MAP(CIconButton, CWnd)
	ON_WM_PAINT()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
END_MESSAGE_MAP()



// CIconButton bZ[W nh
void CIconButton::OnPaint()
{
	CPaintDC dc(this); // device context for painting

	DrawItem(m_isSelect,0);
}

//	쐬
int CIconButton::Create(CWnd *par,CString text,UINT iconID,CPoint pt,int id)
{
	m_id = id;
	m_isSelect = 0;
	m_text = text;
	m_icon = AfxGetApp()->LoadIcon(iconID);
	m_select = AfxGetApp()->LoadIcon(IDI_SELECT);


	CWnd::Create(NULL,text,WS_CHILD | WS_VISIBLE,CRect(pt,CPoint(pt.x + WIDTH,pt.y + HEIGHT)),par,id);
	return 0;
}

//	}EXCxg
void CIconButton::OnMouseMove(UINT nFlags, CPoint point)
{
	CRect	client;

	GetClientRect(client);
	if(client.PtInRect(point))
	{
		SetCapture();
		DrawItem(m_isSelect,1,0);
	}
	else
	{
		DrawItem(m_isSelect,0,0);
		ReleaseCapture();
	}
		
	CWnd::OnMouseMove(nFlags, point);
}

//	`
void CIconButton::DrawItem(int sel,int fover,int iconDraw)
{
	CClientDC 	dc(this);

	//	I̕`
	if(sel)
		dc.DrawIcon(WIDTH - 16,18,m_select);
	else
		dc.FillSolidRect(WIDTH - 16,18,16,16,TEXT_COLOR_WHITE);

	if(!fover)
		dc.SetTextColor(TEXT_COLOR_GRAY);
	else
		dc.SetTextColor(TEXT_COLOR_BLUE);


	//	eLXg`
	CFontSelector bold(&dc,GET_GDI().m_fBold);
	dc.SetBkMode(TRANSPARENT);
	dc.TextOut(50,19,m_text);

	if(iconDraw)
	{
		//	ACR̕`
		dc.DrawIcon(10,9,m_icon);
		CRect	client;
		GetClientRect(client);

		//	̕`
		CPenSelector	gray(&dc,GET_GDI().m_pGray);
		dc.MoveTo(LINE_PADDING,client.bottom-1);
		dc.LineTo(client.right - LINE_PADDING - 2,client.bottom-1);
	}
}

//	I
void CIconButton::SetSelect(int sel)
{
	m_isSelect = sel;
	DrawItem(m_isSelect,m_isSelect);
}

//	擾
int	CIconButton::GetSelect()
{
	return(m_isSelect);
}

//	NbN
void CIconButton::OnLButtonDown(UINT nFlags, CPoint point)
{
	GET_APP()->ClickSound();
	SetFocus();

	GetParent()->PostMessage(USER_MESG_CHANGE_SEL,m_id,0);

	CWnd::OnLButtonDown(nFlags, point);
}

BOOL CIconButton::PreCreateWindow(CREATESTRUCT& cs)
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	HCURSOR cur = ::LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW));
	if(::LoadCursor(NULL ,MAKEINTRESOURCE(IDC_HAND)))
		cur = ::LoadCursor(NULL ,MAKEINTRESOURCE(IDC_HAND));

	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		cur, GET_GDI().m_bWhite, NULL);

	return TRUE;
}
