// IconButton.cpp : t@C
//

#include "stdafx.h"
#include "IconButton2.h"
#include "ServerController.h"

#include <Winuser.h>

//	{^̃TCY1
#define	WIDTH	90
#define	HEIGHT	48


// CIconButton2
CIconButton2::CIconButton2()
{
	m_tracking = 0;
}

CIconButton2::~CIconButton2()
{
	DestroyWindow();
}


BEGIN_MESSAGE_MAP(CIconButton2, CWnd)
	ON_WM_PAINT()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
END_MESSAGE_MAP()



// CIconButton2 bZ[W nh
void CIconButton2::OnPaint()
{
	CPaintDC dc(this); // device context for painting

	DrawItem(m_isSelect,0);
}

//	쐬
int CIconButton2::Create(CWnd *par,CString text,UINT iconID,CPoint pt,int id,int leftLine)
{
	m_id = id;
	m_isSelect = 0;
	m_text = text;
	m_icon = AfxGetApp()->LoadIcon(iconID);
	m_select = AfxGetApp()->LoadIcon(IDI_SELECT);
	m_leftLine = leftLine;


	CWnd::Create(NULL,text,WS_CHILD | WS_VISIBLE,CRect(pt,CPoint(pt.x + WIDTH,pt.y + HEIGHT)),par,id);
	return 0;
}

//	}EXCxg
void CIconButton2::OnMouseMove(UINT nFlags, CPoint point)
{
	CRect	client;

	GetClientRect(client);
	if(client.PtInRect(point))
	{
		SetCapture();
		DrawItem(m_isSelect,1,0);
	}
	else
	{
		DrawItem(m_isSelect,0,0);
		ReleaseCapture();
		m_tracking = 0;
	}
		
	CWnd::OnMouseMove(nFlags, point);
}

//	`
void CIconButton2::DrawItem(int sel,int fover,int iconDraw)
{
	CClientDC 	dc(this);

	if(!fover)
		dc.SetTextColor(TEXT_COLOR_GRAY);
	else
		dc.SetTextColor(TEXT_COLOR_BLUE);


	//	eLXg`
	CFontSelector bold(&dc,GET_GDI().m_fBold);
	dc.SetBkMode(TRANSPARENT);
	dc.TextOut(50,19,m_text);

	if(iconDraw)
	{
		//	ACR̕`
		dc.DrawIcon(10,8,m_icon);
		CRect	client;
		GetClientRect(client);

		//	̕`
		CPenSelector	gray(&dc,GET_GDI().m_pGray);
		dc.MoveTo(client.right - 1,LINE_PADDING);
		dc.LineTo(client.right - 1,client.bottom - LINE_PADDING - 1);

		if(m_leftLine)
		{
			dc.MoveTo(client.left,LINE_PADDING);
			dc.LineTo(client.left,client.bottom - LINE_PADDING - 1);
		}
	}
}

//	I
void CIconButton2::SetSelect(int sel)
{
	m_isSelect = sel;
	DrawItem(m_isSelect,m_isSelect);
}

//	擾
int	CIconButton2::GetSelect()
{
	return(m_isSelect);
}

//	NbN
void CIconButton2::OnLButtonDown(UINT nFlags, CPoint point)
{
	SetFocus();
	m_tracking = 1;
	CWnd::OnLButtonDown(nFlags, point);
}

void CIconButton2::OnLButtonUp(UINT nFlags, CPoint point)
{
	if(m_tracking)
	{
		GET_APP()->ClickSound();
		GetParent()->PostMessage(USER_MESG_TOOL_CLICK,m_id,0);

		Invalidate();
	}

	m_tracking = 0;
	CWnd::OnLButtonUp(nFlags, point);
}

BOOL CIconButton2::PreCreateWindow(CREATESTRUCT& cs)
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	HCURSOR cur = ::LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW));
	if(::LoadCursor(NULL ,MAKEINTRESOURCE(IDC_HAND)))
		cur = ::LoadCursor(NULL ,MAKEINTRESOURCE(IDC_HAND));

	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		cur, GET_GDI().m_bWhite, NULL);

	return TRUE;
}

