// MessageSettingDialog.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "MessageSettingDialog.h"
#include ".\messagesettingdialog.h"


static char messages[5][100] = 
{
	"HTTPS ̃ANZX́AĂ܂",
	"HTTP ̃ANZX́AĂ܂",
	"ANZX́AĂ܂",
	"PzXg̍őڑ𒴂܂",
	"̃t@CEfBNgւ̃ANZX́AĂ܂",
};
static int codes[5] = {403,403,403,503,403};

// CMessageSettingDialog _CAO

IMPLEMENT_DYNAMIC(CMessageSettingDialog, CDialog)
CMessageSettingDialog::CMessageSettingDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CMessageSettingDialog::IDD, pParent)

{
	for(int i=0;i<5;i++)
	{
		m_message[i] = messages[i];
		m_code[i] = codes[i];
	}
}

CMessageSettingDialog::~CMessageSettingDialog()
{
}

void CMessageSettingDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_MES1, m_message[0]);
	DDX_Text(pDX, IDC_MES2, m_message[1]);
	DDX_Text(pDX, IDC_MES3, m_message[2]);
	DDX_Text(pDX, IDC_MES4, m_message[3]);
	DDX_Text(pDX, IDC_MES5, m_message[4]);
	DDX_Text(pDX, IDC_CODE1, m_code[0]);
	DDX_Text(pDX, IDC_CODE2, m_code[1]);
	DDX_Text(pDX, IDC_CODE3, m_code[2]);
	DDX_Text(pDX, IDC_CODE4, m_code[3]);
	DDX_Text(pDX, IDC_CODE5, m_code[4]);
	DDV_MinMaxInt(pDX, m_code[0], 100, 1000);
	DDV_MinMaxInt(pDX, m_code[1], 100, 1000);
	DDV_MinMaxInt(pDX, m_code[2], 100, 1000);
	DDV_MinMaxInt(pDX, m_code[3], 100, 1000);
	DDV_MinMaxInt(pDX, m_code[4], 100, 1000);
}


BEGIN_MESSAGE_MAP(CMessageSettingDialog, CDialog)
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
	ON_BN_CLICKED(IDC_OPEN_DIR, OnBnClickedOpenDir)
	ON_BN_CLICKED(IDC_SET_DEFAULT, OnBnClickedSetDefault)
END_MESSAGE_MAP()


// CMessageSettingDialog bZ[W nh

BOOL CMessageSettingDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	CConfigAccess infoMessage = GET_APP()->m_setting.GetAccess("InfoMessage");
	m_message[0] = infoMessage.GetConfig("DeniedHTTPS",messages[0]);
	m_message[1] = infoMessage.GetConfig("DeniedHTTP",messages[1]);
	m_message[2] = infoMessage.GetConfig("KickHost",messages[2]);
	m_message[3] = infoMessage.GetConfig("ConnectLimit",messages[3]);
	m_message[4] = infoMessage.GetConfig("HiddenDisable",messages[4]);

	m_code[0] = infoMessage.GetConfig("DeniedHTTPSCode",codes[0]);
	m_code[1] = infoMessage.GetConfig("DeniedHTTPCode",codes[1]);
	m_code[2] = infoMessage.GetConfig("KickHostCode",codes[2]);
	m_code[3] = infoMessage.GetConfig("ConnectLimitCode",codes[3]);
	m_code[4] = infoMessage.GetConfig("HiddenDisableCode",codes[4]);

	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CMessageSettingDialog::OnBnClickedOk()
{
	UpdateData();

	CConfigAccess infoMessage = GET_APP()->m_setting.GetAccess("InfoMessage");
	infoMessage.SetConfig("DeniedHTTPS",m_message[0]);
	infoMessage.SetConfig("DeniedHTTP",m_message[1]);
	infoMessage.SetConfig("KickHost",m_message[2]);
	infoMessage.SetConfig("ConnectLimit",m_message[3]);
	infoMessage.SetConfig("HiddenDisable",m_message[4]);

	infoMessage.SetConfig("DeniedHTTPSCode",m_code[0]);
	infoMessage.SetConfig("DeniedHTTPCode",m_code[1]);
	infoMessage.SetConfig("KickHostCode",m_code[2]);
	infoMessage.SetConfig("ConnectLimitCode",m_code[3]);
	infoMessage.SetConfig("HiddenDisableCode",m_code[4]);

	GET_APP()->SaveSetting();
	OnOK();
}

void CMessageSettingDialog::OnBnClickedOpenDir()
{
	CString path = GET_APP()->m_setting.GetConfig("Html::HtmlFileDirectory","%ServerRoot%Html\\");
	path = GET_APP()->GetPathSwap(path);
	::ShellExecute(0, _T("open"), path.GetBuffer(0), 0, 0, SW_SHOWNORMAL);
}

void CMessageSettingDialog::OnBnClickedSetDefault()
{
	for(int i=0;i<5;i++)
	{
		m_message[i] = messages[i];
		m_code[i] = codes[i];
	}
	UpdateData(FALSE);
}