// PathPage3.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "PathPage3.h"


// CPathPage3 _CAO

IMPLEMENT_DYNAMIC(CPathPage3, CPropertyPage)
CPathPage3::CPathPage3(CConfigAccess path)
	: CPropertyPage(CPathPage3::IDD)
	, m_enable(FALSE)
{
	m_pathSetting = path;
}

CPathPage3::~CPathPage3()
{
}

void CPathPage3::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_ENABLE, m_enable);
	DDX_Control(pDX, IDC_ACCEPT, m_accept);
	DDX_Control(pDX, IDC_DENIED, m_denied);
}


BEGIN_MESSAGE_MAP(CPathPage3, CPropertyPage)
	ON_BN_CLICKED(IDC_LRFT, OnBnClickedLrft)
	ON_BN_CLICKED(IDC_RIGHT, OnBnClickedRight)
	ON_NOTIFY(NM_CLICK, IDC_ACCEPT, OnNMClickAccept)
END_MESSAGE_MAP()


// CPathPage3 bZ[W nh

BOOL CPathPage3::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	//	C[WXg̏
	m_imageList.Create(16,16,ILC_COLOR8|ILC_MASK,1,1);
	m_imageList.SetBkColor(::GetSysColor(COLOR_WINDOW));
	m_imageList.Add(GET_APP()->LoadIcon(IDI_USER2));

	CRect	r;
	m_accept.GetClientRect(r);
	m_accept.SetImageList(&m_imageList,LVSIL_SMALL);
	m_accept.InsertColumn(0,_T("[U["),LVCFMT_LEFT,r.Width()-1);

	//	̃[U[̓ǂݍ
	{
		CConfigAccess acceptUsers = m_pathSetting.GetAccess("Users");
		CStringArray	list;
		acceptUsers.GetAllKey(list);
		for(int i=0;i<list.GetSize();i++)
		{
			CStringListCtrl::CListItem	add;

			add.m_text = acceptUsers.GetConfig(list[i],"");
			m_accept.Add(add);
		}
	}

	m_denied.GetClientRect(r);
	m_denied.SetImageList(&m_imageList,LVSIL_SMALL);
	m_denied.InsertColumn(0,_T("[U["),LVCFMT_LEFT,100);
	m_denied.InsertColumn(1,_T("Rg"),LVCFMT_LEFT,r.Width() - 100);


	//	[U[Xg̓ǂݍ
	{
		CConfigAccess enableUsers = GET_APP()->m_setting.GetAccess("User::Enable");
		CStringArray	list;
		enableUsers.GetAllSubNode(list);
		for(int i=0;i<list.GetSize();i++)
		{
			CConfigAccess user = enableUsers.GetAccess(list[i]);
			CStringListCtrl::CListItem	add;

			add.m_text = user.GetConfig("User","");
			add.m_subText.Add(user.GetConfig("Comment",""));
			m_denied.Add(add);
		}
	}


	m_accept.UpdateList();
	m_denied.UpdateList();

	m_enable = m_pathSetting.GetConfig("Options::EnableAuthenticate",0);
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

//	
void CPathPage3::OnBnClickedLrft()
{
	m_accept.CopySelectedItem(m_denied,0,1);
	m_accept.UpdateList();
	m_denied.UpdateList();
}

//	
void CPathPage3::OnBnClickedRight()
{
	m_accept.DeleteSelectedItem();
	m_accept.UpdateList();
}

//	
BOOL CPathPage3::OnKillActive()
{
	UpdateData();
	m_pathSetting.SetConfig("Options::EnableAuthenticate",m_enable);

	//	[U[̏o
	m_pathSetting.DeleteNode("Users");
	CConfigAccess acceptUsers = m_pathSetting.GetAccess("Users");

	int	i,len = m_accept.GetSize();
	for(i=0;i<len;i++)
	{
		acceptUsers.SetConfig(m_accept[i].m_text,m_accept[i].m_text);
	}

	return CPropertyPage::OnKillActive();
}

void CPathPage3::OnNMClickAccept(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	*pResult = 0;
}
