#include "StdAfx.h"
#include "servercontrolinterface.h"
#include "ServerController.h"

CServerControlInterface::CServerControlInterface(void)
{
	m_serverLoaded = 0;
}

CServerControlInterface::~CServerControlInterface(void)
{
	//	CoUninitializeȂ̂ŁÃR[h͗
/*
	if(m_serverLoaded)
		m_serverControl.Release();
	m_serverLoaded = 0;
*/
}

//	T[o[Rg[C^[tF[X[h
int CServerControlInterface::LoadServerControl()
{
	try
	{
		//	T[oRg[̃CX^X
		HRESULT hr = m_serverControl.CreateInstance(__uuidof(ServerControl));
		if(FAILED(hr))
		{
			//	T[o[o^āAgC
			RegisterServer();
			
			hr = m_serverControl.CreateInstance(__uuidof(ServerControl));
			if(FAILED(hr))
				return(-1);
		}

		m_serverLoaded = 1;
	}
	catch(const _com_error& Err)
	{
		TRACE("ComError : %s\n",Err.ErrorMessage());
		return(-1);
	}

	return(0);
}

//	[X
void CServerControlInterface::ReleaseControl()
{
	if(m_serverLoaded)
		m_serverControl.Release();
	m_serverLoaded = 0;
}

//	T[o[̎sJn
int CServerControlInterface::StartServer()
{
	try
	{
		if(m_serverLoaded)
			return(m_serverControl->StartServer());
	}
	catch(const _com_error& Err)
	{
		TRACE("ComError : %s\n",Err.ErrorMessage());
		return(-1);
	}

	return(-1);
}

//	T[o̒~
void CServerControlInterface::StopServer()
{
	try
	{
		if(m_serverLoaded)
			m_serverControl->StopServer();
	}
	catch(const _com_error& Err)
	{
		TRACE("ComError : %s\n",Err.ErrorMessage());
	}
}

//	T[õG[擾
CString CServerControlInterface::GetServerErrorString()
{
	try
	{
		if(m_serverLoaded)
		{
			_bstr_t ret = m_serverControl->GetServerErrorString();
			return((char *)ret);
		}
	}
	catch(const _com_error& Err)
	{
		TRACE("ComError : %s\n",Err.ErrorMessage());
		return("T[o[Ƃ̒ʐMɎs܂AAvP[VċNĂB");
	}

	return("T[o[Ƃ̒ʐMɎs܂AAvP[VċNĂB");
}

//	s擾
int CServerControlInterface::IsRunning()
{
	try
	{
		if(m_serverLoaded)
			return(m_serverControl->IsRunning());
	}
	catch(const _com_error& Err)
	{
		TRACE("ComError : %s\n",Err.ErrorMessage());
		return(0);
	}

	return(0);
}

//	T[rX擾
int CServerControlInterface::IsService()
{
	try
	{
		if(m_serverLoaded)
			return(m_serverControl->IsService());
	}
	catch(const _com_error& Err)
	{
		TRACE("ComError : %s\n",Err.ErrorMessage());
		return(0);
	}

	return(0);
}

//	ANZX擾
int CServerControlInterface::IsActive()
{
	try
	{
		if(m_serverLoaded)
			return(m_serverControl->IsActive());
	}
	catch(const _com_error& Err)
	{
		TRACE("ComError : %s\n",Err.ErrorMessage());
		return(0);
	}

	return(0);
}

//	Info̎擾
CString CServerControlInterface::GetServerInfo()
{
	try
	{
		if(m_serverLoaded)
		{
			_bstr_t ret = m_serverControl->GetServerInfo();
			return((char *)ret);
		}
	}
	catch(const _com_error& Err)
	{
		TRACE("ComError : %s\n",Err.ErrorMessage());
		return("");
	}

	return("");
}

//	Setting擾
CString CServerControlInterface::GetServerSetting()
{
	try
	{
		if(m_serverLoaded)
		{
			_bstr_t ret = m_serverControl->GetServerSetting();
			return((char *)ret);
		}
	}
	catch(const _com_error& Err)
	{
		TRACE("ComError : %s\n",Err.ErrorMessage());
		return("");
	}

	return("");
}

//	Context擾
CString CServerControlInterface::GetServerContext()
{
	try
	{
		if(m_serverLoaded)
		{
			_bstr_t ret = m_serverControl->GetServerContext();
			return((char *)ret);
		}
	}
	catch(const _com_error& Err)
	{
		TRACE("ComError : %s\n",Err.ErrorMessage());
		return("");
	}

	return("");
}


//	T[o[g擾
CString CServerControlInterface::GetServerRoot()
{
	try
	{
		if(m_serverLoaded)
		{
			_bstr_t ret = m_serverControl->GetServerRoot();
			return((char *)ret);
		}
	}
	catch(const _com_error& Err)
	{
		TRACE("ComError : %s\n",Err.ErrorMessage());
		return("");
	}

	return("");
}

//	AvP[V[hŃT[oo^
void CServerControlInterface::RegisterServer()
{
	TRACE("T[o[o^܂B\n");

	CString	command = GET_APP()->GetAppPath() + "04WebServer.exe /InstallApp";

	STARTUPINFO StartupInfo;
	PROCESS_INFORMATION ProcessInfo;

	::ZeroMemory(&StartupInfo, sizeof(STARTUPINFO));
	StartupInfo.cb = sizeof(STARTUPINFO);
	::ZeroMemory(&ProcessInfo, sizeof(PROCESS_INFORMATION));

	int err = CreateProcess(	NULL,
								command.GetBuffer(0),
								NULL,
								NULL,
								FALSE,
								0,
								NULL,
								NULL,
								&StartupInfo,
								&ProcessInfo);

	if(err==0)
		return;

	//	I܂ő҂
	WaitForSingleObject(ProcessInfo.hProcess,INFINITE);

	return;
}
