// ServerPage3.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "ServerPage3.h"

#define	LOG_NAME_DEFAULT		"%ServerRoot%Logs\\%Year%%Month%%Day%.txt"
#define	SYSTEM_LOG_NAME_DEFAULT	"%ServerRoot%Logs\\SystemLog.txt"
#define	LOG_FORMAT_DEFAULT		"[%Time%] <%Host%> (%RecvSize%,%SendSize%) [%Info%] %Method% %Object%"
#define	LOG_FORMAT_APACHE		"%Host% - %User% [%Day%/%MonthString%/%Year%:%Time% +0900] \"%Method% %Object% HTTP/%Version%\" %ResponseCode% %SendSize% \"%Referer%\" \"%User-Agent%\""

// CServerPage3 _CAO

IMPLEMENT_DYNAMIC(CServerPage3, CPropertyPage)
CServerPage3::CServerPage3()
	: CPropertyPage(CServerPage3::IDD)
	, m_fileName(_T(""))
	, m_logFormat(_T(""))
	, m_systemLog(_T(""))
{
}

CServerPage3::~CServerPage3()
{
}

void CServerPage3::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT1, m_fileName);
	DDX_Text(pDX, IDC_EDIT2, m_logFormat);
	DDX_Text(pDX, IDC_EDIT4, m_systemLog);
}


BEGIN_MESSAGE_MAP(CServerPage3, CPropertyPage)
	ON_BN_CLICKED(IDC_DEFAULT1, OnBnClickedDefault1)
	ON_BN_CLICKED(IDC_DEFAULT2, OnBnClickedDefault2)
	ON_BN_CLICKED(IDC_DEFAULT3, OnBnClickedDefault3)
	ON_BN_CLICKED(IDC_APACHE, OnBnClickedApache)
END_MESSAGE_MAP()


// CServerPage3 bZ[W nh

BOOL CServerPage3::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	m_fileName = GET_APP()->m_setting.GetConfig("Log::LogFilePath",LOG_NAME_DEFAULT);
	m_logFormat = GET_APP()->m_setting.GetConfig("Log::LogFormatNoTime",LOG_FORMAT_DEFAULT);
	m_systemLog = GET_APP()->m_setting.GetConfig("Log::SystemLogFilePath",SYSTEM_LOG_NAME_DEFAULT);

	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

BOOL CServerPage3::OnKillActive()
{
	UpdateData();
	GET_APP()->m_setting.SetConfig("Log::LogFilePath",m_fileName);
	GET_APP()->m_setting.SetConfig("Log::LogFormatNoTime",m_logFormat);
	GET_APP()->m_setting.SetConfig("Log::SystemLogFilePath",m_systemLog);

	return CPropertyPage::OnKillActive();
}

void CServerPage3::OnBnClickedDefault1()
{
	UpdateData();
	m_fileName = LOG_NAME_DEFAULT;
	UpdateData(FALSE);
}

void CServerPage3::OnBnClickedDefault2()
{
	UpdateData();
	m_logFormat = LOG_FORMAT_DEFAULT;
	UpdateData(FALSE);
}

void CServerPage3::OnBnClickedApache()
{
	UpdateData();
	m_logFormat = LOG_FORMAT_APACHE;
	UpdateData(FALSE);
}

void CServerPage3::OnBnClickedDefault3()
{
	UpdateData();
	m_systemLog = SYSTEM_LOG_NAME_DEFAULT;
	UpdateData(FALSE);
}

