// SideBar.cpp : t@C
//

#include "stdafx.h"
#include "SideBar.h"
#include "resource.h"       // C V{
#include "ServerController.h"


// CSideBar

//IMPLEMENT_DYNAMIC(CSideBar, CWnd)
CSideBar::CSideBar()
{
	m_logo.LoadBitmap(IDB_LOGO);
	m_logoDc.CreateCompatibleDC(NULL);
	m_logoDc.SelectObject(m_logo);
}

CSideBar::~CSideBar()
{
}


BEGIN_MESSAGE_MAP(CSideBar, CWnd)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_MESSAGE( USER_MESG_CHANGE_SEL, OnChangeSel )
END_MESSAGE_MAP()



// CSideBar bZ[W nh


void CSideBar::OnPaint()
{
	CPaintDC dc(this); // device context for painting


	CRect	client;
	GetClientRect(client);

	//	rbg}bv`
	dc.BitBlt(0,client.bottom-110,185,110,&m_logoDc,0,0,SRCCOPY);


	CPenSelector	gray(&dc,GET_GDI().m_pGray);
	dc.MoveTo(client.right - LINE_PADDING - 1,LINE_PADDING);
	dc.LineTo(client.right - LINE_PADDING - 1,client.bottom - LINE_PADDING);

	CPenSelector	light(&dc,GET_GDI().m_pLight);
	dc.MoveTo(client.right - LINE_PADDING,LINE_PADDING);
	dc.LineTo(client.right - LINE_PADDING,client.bottom - LINE_PADDING - 1);

	if(GET_APP()->m_wantRestart)
	{
		CFontSelector bold(&dc,GET_GDI().m_fBold);
		dc.SetTextColor(TEXT_COLOR_RED);
		dc.TextOut(10,client.bottom - 94,"ݒLɂ邽߂ɂ́A");
		dc.TextOut(10,client.bottom - 80,"T[oċNĂB");
	}

}

BOOL CSideBar::PreCreateWindow(CREATESTRUCT& cs)
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), GET_GDI().m_bWhite, NULL);

	return TRUE;
}

int CSideBar::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if(m_select[0].Create(this,"T[o",IDI_SERVER,CPoint(0,0),SIDE_BAR_COMMAND_START))
		TRACE("Cannot create\n");

	if(m_select[1].Create(this,"fBNgݒ",IDI_DIR_INFO,CPoint(0,50),SIDE_BAR_COMMAND_START + 1))
		TRACE("Cannot create\n");

	if(m_select[2].Create(this,"T[oݒ",IDI_TOOL,CPoint(0,100),SIDE_BAR_COMMAND_START + 2))
		TRACE("Cannot create\n");

	if(m_select[3].Create(this,"ڑ",IDI_EARTH,CPoint(0,150),SIDE_BAR_COMMAND_START + 3))
		TRACE("Cannot create\n");

	SendMessage(USER_MESG_CHANGE_SEL,SIDE_BAR_COMMAND_START,0);

	return 0;
}

//	Iڂ̕ύX
LRESULT CSideBar::OnChangeSel(WPARAM wParam, LPARAM lParam)
{
	int	sel = (int)wParam - SIDE_BAR_COMMAND_START;

	for(int i=0;i<MAX_SELECT;i++)
		m_select[i].SetSelect(0);
	m_select[sel].SetSelect(1);

	GetParent()->SendMessage(USER_MESG_CHANGE_SEL,wParam,lParam);

	return(0);
}



