// BandWidthDialog.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "BandWidthDialog.h"


// CBandWidthDialog _CAO

IMPLEMENT_DYNAMIC(CBandWidthDialog, CDialog)
CBandWidthDialog::CBandWidthDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CBandWidthDialog::IDD, pParent)
	, m_sendServer(0)
	, m_sendHost(0)
	, m_sendConnect(0)
	, m_recvServer(0)
	, m_recvHost(0)
	, m_recvConnect(0)
{
}

CBandWidthDialog::~CBandWidthDialog()
{
}

void CBandWidthDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_SEND_SERVER, m_sendServer);
	DDX_Text(pDX, IDC_SEND_HOST, m_sendHost);
	DDX_Text(pDX, IDC_SEND_CONNECT, m_sendConnect);
	DDX_Text(pDX, IDC_RECV_SERVER, m_recvServer);
	DDX_Text(pDX, IDC_RECV_HOST, m_recvHost);
	DDX_Text(pDX, IDC_RECV_CONNECT, m_recvConnect);
}


BEGIN_MESSAGE_MAP(CBandWidthDialog, CDialog)
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
END_MESSAGE_MAP()


// CBandWidthDialog bZ[W nh

BOOL CBandWidthDialog::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	CWorkspaceAccess sendLimit = GET_APP()->m_setting.GetAccess("Limit::Send");
	m_sendServer = sendLimit.GetConfig("MaxServerBandWidth",0);
	m_sendHost = sendLimit.GetConfig("MaxOneHostBandWidth",0);
	m_sendConnect = sendLimit.GetConfig("MaxOneConnectBandWidth",0);

	CWorkspaceAccess recvLimit = GET_APP()->m_setting.GetAccess("Limit::Recv");
	m_recvServer = recvLimit.GetConfig("MaxServerBandWidth",0);
	m_recvHost = recvLimit.GetConfig("MaxOneHostBandWidth",0);
	m_recvConnect = recvLimit.GetConfig("MaxOneConnectBandWidth",0);

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CBandWidthDialog::OnBnClickedOk()
{
	UpdateData(TRUE);

	CWorkspaceAccess sendLimit = GET_APP()->m_setting.GetAccess("Limit::Send");
	sendLimit.SetConfig("MaxServerBandWidth",m_sendServer);
	sendLimit.SetConfig("MaxOneHostBandWidth",m_sendHost);
	sendLimit.SetConfig("MaxOneConnectBandWidth",m_sendConnect);

	CWorkspaceAccess recvLimit = GET_APP()->m_setting.GetAccess("Limit::Recv");
	recvLimit.SetConfig("MaxServerBandWidth",m_recvServer);
	recvLimit.SetConfig("MaxOneHostBandWidth",m_recvHost);
	recvLimit.SetConfig("MaxOneConnectBandWidth",m_recvConnect);

	GET_APP()->SaveSetting();
	OnOK();
}
