// Buffer.cpp: CBuffer NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Buffer.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define	GROW_SIZE	32768

//////////////////////////////////////////////////////////////////////
//	TCYw肵ď
//////////////////////////////////////////////////////////////////////
/*!
	\param size	TCY
*/
CBuffer::CBuffer(int size)
{
	Init();
	Alloc(size);
}

//////////////////////////////////////////////////////////////////////
//	Rs[RXgN^
//////////////////////////////////////////////////////////////////////
/*!
	\param other	̃NX
*/
CBuffer::CBuffer(CBuffer &other)
{
	Init();
	Alloc(other.GetSize());
	memmove(m_buffer,other.GetPtr(),other.GetSize());
}


//////////////////////////////////////////////////////////////////////
//	fXgN^
//////////////////////////////////////////////////////////////////////
CBuffer::~CBuffer()
{
	delete m_buffer;
	Init();
}

//////////////////////////////////////////////////////////////////////
//	
//////////////////////////////////////////////////////////////////////
void CBuffer::Init()
{
	m_buffer = NULL;
	m_bufferSize = 0;
	m_usingSize = 0;
	SetGrowSize(GROW_SIZE);
}


//////////////////////////////////////////////////////////////////////
// m
//////////////////////////////////////////////////////////////////////
/*!
	\param size	mۃTCY
*/
void CBuffer::Alloc(int size)
{
	if(size > m_bufferSize)
	{
		unsigned char *temp = new unsigned char[size + m_growSize];
		int	transSize = m_bufferSize;

		if(m_buffer)
		{
			if(m_bufferSize > size)
				transSize = size;

			memmove(temp,m_buffer,transSize);
			delete m_buffer;
		}

		m_buffer = temp;
		m_bufferSize = size + m_growSize;
		m_usingSize = size;
	}
}


//////////////////////////////////////////////////////////////////////
// ǉ
//////////////////////////////////////////////////////////////////////
/*!
	\param data	f[^
	\param size TCY
*/
void CBuffer::Append(const char *data, int size)
{
	int	oldSize = GetSize();
	ReSize(size + oldSize);

	memmove(GetPtr() + oldSize,data,size);	
}


//////////////////////////////////////////////////////////////////////
// TCYύX
//////////////////////////////////////////////////////////////////////
/*!
	ύXÕf[^͕ی삳邪AύXオ̃TCY菬ꍇÃf[^͐؂̂Ă<br>

	\param size ύXTCY
*/
void CBuffer::ReSize(int size)
{
	if(size > m_bufferSize)
	{
		Alloc(size);
	}
	m_usingSize = size;
}

//////////////////////////////////////////////////////////////////////
// 폜
//////////////////////////////////////////////////////////////////////
/*!
	start  start + size Ԃł̃f[^폜B<br>
	f[^͐؂l߂B

	\param start	폜Jn_
	\param size		폜TCY
*/
void CBuffer::Remove(int start,int size)
{
	if(start < 0 || size < 0 || start + size > m_usingSize)
		return;

	memmove(GetPtr() + start,GetPtr() + size,m_usingSize - (start + size));
	m_usingSize = m_usingSize - size;
}

//////////////////////////////////////////////////////////////////////
// 擾
//////////////////////////////////////////////////////////////////////
char * CBuffer::GetPtr()
{
	return((char *)m_buffer);
}

CBuffer::operator char*()
{
	return((char *)m_buffer);
}

CBuffer::operator CString()
{
	CString ret;
	char * buf = ret.GetBuffer(m_usingSize + 1);
	memcpy(buf,m_buffer,m_usingSize);
	buf[m_usingSize] = 0;
	ret.ReleaseBuffer();

	return(ret);
}

CBuffer::operator unsigned char*()
{
	return(m_buffer);
}

int CBuffer::GetSize()
{
	return(m_usingSize);
}

void CBuffer::operator =(CString &other)
{
	ReSize(other.GetLength());
	memmove(m_buffer,other.GetBuffer(0),m_usingSize);
}

void CBuffer::operator =(CBuffer &other)
{
	ReSize(other.GetSize());
	memmove(m_buffer,other.GetPtr(),m_usingSize);
}

void CBuffer::operator +=(CString &other)
{
	Append(other.GetBuffer(0),other.GetLength());
}

void CBuffer::operator +=(CBuffer &other)
{
	Append(other.GetPtr(),other.GetSize());
}

void CBuffer::operator +=(const char *other)
{
	int	len = (int)strlen(other);
	Append(other,len);
}

void CBuffer::operator +=(char other)
{
	Append(&other,1);
}


//////////////////////////////////////////////////////////////////////
// f[^Rs[
//////////////////////////////////////////////////////////////////////
/*!
	offset  len oCgAdata Rs[i㏑j܂B

	\param offset	Rs[Jnn_
	\param data		f[^
	\param len		f[^
*/
void CBuffer::BlockCopy(int offset, const char *data, int len)
{
	if(offset + len >= m_usingSize)
		ReSize(offset + len);
	memmove(m_buffer + offset,data,len);
}

//////////////////////////////////////////////////////////////////////
// ݒ
//////////////////////////////////////////////////////////////////////
/*!
	\param size		TCY
*/
void CBuffer::SetGrowSize(int size)
{
	m_growSize = size;
}


//////////////////////////////////////////////////////////////////////
// UTF8
//////////////////////////////////////////////////////////////////////
/*!
	BSTRUFT8ɕϊĐݒ
	\param bstr		
*/

void CBuffer::SetUTF8(_bstr_t bstr)
{
	//	UTF8֕ϊ
	int mbLen = WideCharToMultiByte(CP_UTF8,0,bstr.GetBSTR(),bstr.length(),NULL,0,NULL,NULL);

	ReSize(mbLen);
	WideCharToMultiByte(CP_UTF8,0,bstr.GetBSTR(),bstr.length(),GetPtr(),GetSize(),NULL,NULL);
}


/*!
	BSTRɕϊ
	\return		
*/
_bstr_t CBuffer::GetBSTR()
{
	int mbLen = MultiByteToWideChar(CP_UTF8,0,GetPtr(),GetSize(),NULL,0);

	wchar_t	*wstr = new wchar_t[mbLen + 1];
	MultiByteToWideChar(CP_UTF8,0,GetPtr(),GetSize(),wstr,mbLen);
	wstr[mbLen] = 0;

	_bstr_t	ret(wstr);
	delete wstr;

	return(ret);
}

//////////////////////////////////////////////////////////////////////
// ۑ
//////////////////////////////////////////////////////////////////////
/*!
	t@C֕ۑ

	\param path		pX
*/
int CBuffer::SaveToFile(CString path)
{
	FILE	*out;
	if(fopen_s(&out ,path,"wb") != 0)
		return(-1);

	fwrite(GetPtr(),GetSize(),1,out);
	fclose(out);
	return(0);
}

int CBuffer::LoadFromFile(CString path)
{
	FILE	*out;
	if(fopen_s(&out ,path,"rb") != 0)
		return(-1);
	
	fseek(out,0,SEEK_END);
	long	len = ftell(out);
	fseek(out,0,SEEK_SET);

	ReSize(len);
	fread(GetPtr(),GetSize(),1,out);
	fclose(out);
	return(0);
}

