// FileIconDialog.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "FileIconDialog.h"


// CFileIconDialog _CAO

IMPLEMENT_DYNAMIC(CFileIconDialog, CDialog)
CFileIconDialog::CFileIconDialog(int type,CWnd* pParent /*=NULL*/)
	: CDialog(CFileIconDialog::IDD, pParent)
{
	m_type = type;
}

CFileIconDialog::~CFileIconDialog()
{
}

void CFileIconDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT, m_edit);
}


BEGIN_MESSAGE_MAP(CFileIconDialog, CDialog)
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
END_MESSAGE_MAP()


// CFileIconDialog bZ[W nh

BOOL CFileIconDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_font.CreateFont(14,0,0,0,FW_NORMAL,FALSE,FALSE,FALSE,
							SHIFTJIS_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
							DEFAULT_QUALITY,DEFAULT_PITCH,"");

	m_edit.SetLimitText(80 * 3000);
	m_edit.SetWindowText(GetSettingString());
	m_edit.SetFont(&m_font);

	if(m_type==0)
		SetWindowText("t@CEACR̐ݒ");
	else
		SetWindowText("MIME^Cv̐ݒ");

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}


void CFileIconDialog::OnBnClickedOk()
{
	if(ParseText())
		return;

	CString	text;
	m_edit.GetWindowText(text);

	if(m_type == 0)
		GET_APP()->m_setting.SetConfig("IconType::Text",text);
	else
		GET_APP()->m_setting.SetConfig("MimeType::Text",text);
	GET_APP()->SaveSetting();

	OnOK();
}

//	擾
CString CFileIconDialog::GetSettingString()
{
	CString	str;
	if(m_type == 0)
		str = GET_APP()->m_setting.GetConfig("IconType::Text","");
	else
		str = GET_APP()->m_setting.GetConfig("MimeType::Text","");
	str.Replace("\r\n","\n");
	str.Replace("\r","\n");
	str.Replace("\n","\r\n");

	return(str);
}

//	
int CFileIconDialog::ParseText()
{
	if(m_type == 0)
	{
		CWorkspace	config;
		CWorkspaceAccess	icon = config.GetAccess("IconType");

		CString text,line;
		m_edit.GetWindowText(text);
		int textLen = text.GetLength(),lineCount=0;
		while(GetLine(text,line))
		{
			lineCount++;
			line.Trim();
			
			//	RgAsH
			if(line.IsEmpty() || line[0] == '#' || line.Left(2) == "//")
				continue;

			//	s
			CStringArray	list;
			int count = ParseLine(line,list);

			//	OK
			if(list.GetSize() > 1)
			{
				CString	ext;
				CWorkspaceAccess sub = icon.GetAccess(list[0]);
				for(int i=1;i<list.GetSize();i++)
				{
					ext.Format("Filter_%02d",i-1);
					sub.SetConfig(ext,list[i]);
				}
			}
		}

		GET_APP()->m_setting.GetAccess("IconType").Copy(icon);
	}
	else
	{
		CWorkspace	config;
		CWorkspaceAccess	mime = config.GetAccess("MimeType");

		CString text,line;
		m_edit.GetWindowText(text);
		int textLen = text.GetLength(),lineCount=0;
		while(GetLine(text,line))
		{
			lineCount++;
			line.Trim();
			
			//	RgAsH
			if(line.IsEmpty() || line[0] == '#' || line.Left(2) == "//")
				continue;

			//	s
			CStringArray	list;
			int count = ParseLine(line,list);

			//	OK
			if(list.GetSize() > 1)
			{
				CString	ext;
				CWorkspaceAccess sub = mime.GetAccess(list[0]);
				for(int i=1;i<list.GetSize();i++)
				{
					ext.Format("Ext_%02d",i-1);
					sub.SetConfig(ext,list[i]);
				}
			}
		}

		GET_APP()->m_setting.GetAccess("MimeType").Copy(mime);
	}

	return(0);
}

//	C
int CFileIconDialog::ParseLine(CString line, CStringArray &array)
{
	array.RemoveAll();

	//	O
	line.TrimLeft();
	line.TrimRight();
	line.Replace("\t",",");
	line.Replace(" ",",");

	if(line.IsEmpty())
		return(0);

	//	
	int	index = line.Find(",");
	if(index == -1)
	{
		array.Add(line);
		return(1);
	}

	CString	add;
	while(index != -1)
	{
		add = line.Left(index);

		if(!add.IsEmpty())
			array.Add(add);
		line = line.Mid(index + 1);
		index = line.Find(",");
	}
	
	if(!line.IsEmpty())
		array.Add(line);

	return((int)array.GetSize());
}

//////////////////////////////////////////////////////////////////////
// C؂o
//////////////////////////////////////////////////////////////////////
int CFileIconDialog::GetLine(CString &str, CString &line)
{
	int index = str.Find("\r\n");

	if(index == -1)
	{
		if(str.IsEmpty())
			return(0);
		else
		{
			line = str;
			str = "";
			return(1);
		}
	}
	
	//	؂o
	line = str.Left(index);

	//	폜
	str = str.Mid(index + 2);
	return(1);
}
