#pragma once
#include "openssl/rsa.h"

class COpenSSLUtil
{
public:
	class CX509Entry
	{
	public:
		int	m_serialNumber;
		int	m_notBeforeDays;
		int	m_notAfterDays;

		CString	m_countryName;				//	"C"		(2)
		CString	m_statName;					//	"ST"	BEH
		CString	m_localityName;				//	"L"		EsH
		CString	m_organizationName;			//	"O"		ЖEgD
		CString	m_organizationalUnitName;	//	"OU"	H
		CString	m_commonName;				//	"CN"	ǗҖETCgH
		CString	m_email;					//	"Email"	Email
	};

public:
	COpenSSLUtil(void);
	virtual ~COpenSSLUtil(void);

	void SetPassword(CString passwd);
	int GeneratePrivateKey(int bit = 2048);
	int SavePrivateKey(CString path);
	int SaveCSR(CString path,CX509Entry entry);
	int SaveCRT(CString path,CX509Entry entry);

	static int Password_cb(char *buf,int num,int rwflag,void *userdata);
	static void Progress_cb(int p, int n, void *arg);

protected:
	CString	m_password;

	CString GetPassword();
	CString GetRandomString(int count);

	EVP_PKEY	*m_pkey;

};
