// SSICGIPage2.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "SSICGIPage2.h"


// CSSICGIPage2 _CAO

IMPLEMENT_DYNAMIC(CSSICGIPage2, CPropertyPage)
CSSICGIPage2::CSSICGIPage2()
	: CPropertyPage(CSSICGIPage2::IDD)
	, m_ext(_T(""))
{
}

CSSICGIPage2::~CSSICGIPage2()
{
}

void CSSICGIPage2::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_INDEX, m_list);
	DDX_Text(pDX, IDC_EDIT1, m_ext);
}


BEGIN_MESSAGE_MAP(CSSICGIPage2, CPropertyPage)
	ON_BN_CLICKED(IDC_ADD, OnBnClickedAdd)
	ON_BN_CLICKED(IDC_DEL, OnBnClickedDel)
END_MESSAGE_MAP()


// CSSICGIPage2 bZ[W nh

BOOL CSSICGIPage2::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	//	C[WXg̏
	m_imageList.Create(16,16,ILC_COLOR8|ILC_MASK,1,1);
	m_imageList.SetBkColor(::GetSysColor(COLOR_WINDOW));
	m_imageList.Add(GET_APP()->LoadIcon(IDI_IE));

	CRect	r;
	m_list.GetClientRect(r);
	m_list.SetImageList(&m_imageList,LVSIL_SMALL);
	m_list.InsertColumn(0,_T("t@C"),LVCFMT_LEFT,r.Width()-1);


	CWorkspaceAccess index = GET_APP()->m_setting.GetAccess("SSI");
	CStringArray	list;
	index.GetAllKey(list);
	for(int i=0;i<list.GetSize();i++)
	{
		CStringListCtrl::CListItem	add;

		add.m_text = index.GetConfig(list[i],"");
		m_list.Add(add);
	}


	m_list.UpdateList();
	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

BOOL CSSICGIPage2::OnKillActive()
{
	GET_APP()->m_setting.DeleteNode("SSI");
	CWorkspaceAccess index = GET_APP()->m_setting.GetAccess("SSI");

	int	i,len = (int)m_list.GetSize();
	for(i=0;i<len;i++)
	{
		index.SetConfig(m_list[i].m_text,m_list[i].m_text);
	}

	return CPropertyPage::OnKillActive();
}

void CSSICGIPage2::OnBnClickedAdd()
{
	UpdateData();
	m_ext.Trim(".");

	if(!m_ext.IsEmpty())
	{
		CStringListCtrl::CListItem	add;

		add.m_text = m_ext;
		m_list.Add(add);
		m_list.UpdateList();
	}
}

void CSSICGIPage2::OnBnClickedDel()
{
	m_list.DeleteSelectedItem();
	m_list.UpdateList();
}
