// SecndFrame.cpp : t@C
//

#include "stdafx.h"
#include "SecndFrame.h"
#include "directoryview.h"
#include "settingview.h"
#include "serverinfoview.h"
#include "connectinfoview.h"

#define	SIDE_BAR_SIZE	195
#define	HEADER_SIZE		65


// CSecndFrame

IMPLEMENT_DYNAMIC(CSecndFrame, CWnd)
CSecndFrame::CSecndFrame()
{
	m_mainView = NULL;
}

CSecndFrame::~CSecndFrame()
{
	if(m_mainView)
		delete m_mainView;
	m_mainView = NULL;
}


BEGIN_MESSAGE_MAP(CSecndFrame, CWnd)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_MESSAGE( USER_MESG_CHANGE_SEL, OnChangeSel )
	ON_COMMAND(ID_EDIT_COPY_INFO, OnEditCopyInfo)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY_INFO, OnUpdateEditCopyInfo)
END_MESSAGE_MAP()



// CSecndFrame bZ[W nh


void CSecndFrame::OnPaint()
{
	CPaintDC dc(this); // device context for painting
}

int CSecndFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_sideBar.Create(NULL, NULL, WS_CHILD | WS_VISIBLE,
		CRect(0, 0, 0, 0), this, 0, NULL))
	{
		TRACE0("r[ EBhE쐬ł܂łB\n");
		return -1;
	}

	if (!m_header.Create(NULL, NULL, WS_CHILD | WS_VISIBLE,
		CRect(0, 0, 0, 0), this, 1, NULL))
	{
		TRACE0("r[ EBhE쐬ł܂łB\n");
		return -1;
	}

	m_header.SetLabel("T[o","T[o̐ݒT[o̓󋵂ȂǁAT[ȍ\܂B");

	CreateMainView(new CServerInfoView);

	return 0;
}

BOOL CSecndFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;

	return TRUE;
}

void CSecndFrame::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType, cx, cy);

	m_sideBar.MoveWindow(0,0,SIDE_BAR_SIZE,cy);
	m_header.MoveWindow(SIDE_BAR_SIZE,0,cx-SIDE_BAR_SIZE,HEADER_SIZE);

	if(m_mainView)
		m_mainView->MoveWindow(SIDE_BAR_SIZE,HEADER_SIZE,cx-SIDE_BAR_SIZE,cy-HEADER_SIZE);
}

//	Iڂ̕ύX
LRESULT CSecndFrame::OnChangeSel(WPARAM wParam, LPARAM lParam)
{
	int	sel = (int)wParam - SIDE_BAR_COMMAND_START;

	switch(sel)
	{
		case 0:
			m_header.SetLabel("T[o","ڑE]eʂȂǁAT[ȍ\܂B");
			CreateMainView(new CServerInfoView);
			break;

		case 1:
			m_header.SetLabel("fBNgݒ","T[ỏzpXƁAPC̕pX̊֘Ats܂B");
			CreateMainView(new CDirectoryView);
			break;

		case 2:
			m_header.SetLabel("T[oݒ","[U[ݒڑȂǁAT[o̊eݒs܂B");
			CreateMainView(new CSettingView);
			break;

		case 3:
			m_header.SetLabel("ڑ","ݒʐMsĂڑ̊e\܂B");
			CreateMainView(new CConnectInfoView);
			break;
	}

	return(0);
}

//	Cr[̐
void CSecndFrame::CreateMainView(CMainViewBase *view)
{
	//	ÕEChE폜
	if(m_mainView)
		delete m_mainView;
	m_mainView = NULL;
	m_mainView = view;

	CRect	client;
	GetClientRect(client);

	view->Create(NULL, NULL, WS_CHILD | WS_VISIBLE,CRect(SIDE_BAR_SIZE,HEADER_SIZE,client.Width(),client.Height()), this, 0, NULL);
}


//	̃Rs[
void CSecndFrame::OnEditCopyInfo()
{
	SetClipboard(m_mainView->ToString());
}

//	̃Rs[XV
void CSecndFrame::OnUpdateEditCopyInfo(CCmdUI *pCmdUI)
{
	if(m_mainView==NULL)
		return;

	if(m_mainView->ToStringActive())
		pCmdUI->Enable(TRUE);
	else
		pCmdUI->Enable(FALSE);
}

//	Nbv{[hݒ
void CSecndFrame::SetClipboard(CString str)
{
	if (!::OpenClipboard(NULL)) 
	{
		return;
	}

	HGLOBAL	hglb = ::GlobalAlloc(GMEM_DDESHARE | GMEM_MOVEABLE,str.GetLength()+1);
	LPTSTR	lptstr = (LPTSTR)::GlobalLock(hglb);
	memcpy(lptstr,str.GetBuffer(),str.GetLength()+1);
	::GlobalUnlock(hglb);
	::EmptyClipboard();
	::SetClipboardData(CF_TEXT,hglb);
	::CloseClipboard(); 

	return;
}

