#include "StdAfx.h"
#include "ServerControlInterface2.h"
#include "CommandPacket.h"

CServerControlInterface2::CServerControlInterface2(void)
{
}

CServerControlInterface2::~CServerControlInterface2(void)
{
	CloseServerControl();
}

//////////////////////////////////////////////////////////////////////////////////
//	JnE~
//////////////////////////////////////////////////////////////////////////////////
/*!
	T[o֐ڑ
*/
int CServerControlInterface2::OpenServerControl()
{
	Close();
	if(Connect(CONTROL_PIPE_NAME))
		return(-1);
	return(0);
}

/*!
	ڑ
*/
void CServerControlInterface2::CloseServerControl()
{
	Close();
}

//////////////////////////////////////////////////////////////////////////////////
//	
//////////////////////////////////////////////////////////////////////////////////
/*!
	T[oN
*/
int CServerControlInterface2::StartServer()
{
	//	vpPbg
	CCommandPacket	request, responce;
	request.SetCommand(_T("StartServer"));

	//	M
	if(SendCommandPacket(request, responce))
		return(-1);

	//	G[H
	if(!responce.IsSuccess())
		return(-1);
	return(0);
}

/*!
	T[o~
*/
int CServerControlInterface2::StopServer()
{
	//	vpPbg
	CCommandPacket	request, responce;
	request.SetCommand(_T("StopServer"));

	//	M
	if(SendCommandPacket(request, responce))
		return(-1);

	//	G[H
	if(!responce.IsSuccess())
		return(-1);
	return(0);
}

/*!
	s擾
*/
int CServerControlInterface2::IsRunning()
{
	//	vpPbg
	CCommandPacket	request, responce;
	request.SetCommand(_T("IsRunning"));

	//	M
	if(SendCommandPacket(request, responce))
		return(0);

	//	G[H
	if(!responce.IsSuccess())
		return(0);

	return(responce.GetCommandOptionInt(_T("IsRunning")));
}

/*!
	T[rXs擾
*/
int CServerControlInterface2::IsService()
{
	//	vpPbg
	CCommandPacket	request, responce;
	request.SetCommand(_T("IsService"));

	//	M
	if(SendCommandPacket(request, responce))
		return(0);

	//	G[H
	if(!responce.IsSuccess())
		return(0);

	return(responce.GetCommandOptionInt(_T("IsService")));
}

/*!
	ڑ擾
*/
int CServerControlInterface2::GetConnectionCount()
{
	//	vpPbg
	CCommandPacket	request, responce;
	request.SetCommand(_T("GetConnectionCount"));

	//	M
	if(SendCommandPacket(request, responce))
		return(0);

	//	G[H
	if(!responce.IsSuccess())
		return(0);

	return(responce.GetCommandOptionInt(_T("ConnectionCount")));
}

/*!
	G[擾
*/
CString CServerControlInterface2::GetServerErrorString()
{
	//	vpPbg
	CCommandPacket	request, responce;
	request.SetCommand(_T("GetServerErrorString"));

	//	M
	if(SendCommandPacket(request, responce))
		return(_T("T[oƂ̒ʐMɎs܂B"));

	//	G[H
	if(!responce.IsSuccess())
		return(_T("T[oƂ̒ʐMɎs܂B"));

	return(responce.GetCommandOption(_T("ServerErrorString")));
}

/*!
	T[o[g擾
*/
CString CServerControlInterface2::GetServerRoot()
{
	//	vpPbg
	CCommandPacket	request, responce;
	request.SetCommand(_T("GetServerRoot"));

	//	M
	if(SendCommandPacket(request, responce))
		return("");

	//	G[H
	if(!responce.IsSuccess())
		return("");

	return(responce.GetCommandOption(_T("ServerRoot")));
}

/*!
	T[o擾
*/
int CServerControlInterface2::GetServerInfo(CWorkspaceAccess info)
{
	//	vpPbg
	CCommandPacket	request, responce;
	request.SetCommand(_T("GetServerInfo"));

	//	M
	if(SendCommandPacket(request, responce))
		return(-1);

	//	G[H
	if(!responce.IsSuccess())
		return(-1);

	//	擾
	info.Copy(responce.GetAttachedDataAccess());
	return(0);
}

/*!
	T[oݒ擾
*/
int CServerControlInterface2::GetServerSetting(CWorkspaceAccess setting)
{
	//	vpPbg
	CCommandPacket	request, responce;
	request.SetCommand(_T("GetServerSetting"));

	//	M
	if(SendCommandPacket(request, responce))
		return(-1);

	//	G[H
	if(!responce.IsSuccess())
		return(-1);

	//	擾
	setting.Copy(responce.GetAttachedDataAccess());
	return(0);
}

/*!
	T[oReLXg擾
*/
int CServerControlInterface2::GetServerContext(CWorkspaceAccess context)
{
	//	vpPbg
	CCommandPacket	request, responce;
	request.SetCommand(_T("GetServerContext"));

	//	M
	if(SendCommandPacket(request, responce))
		return(-1);

	//	G[H
	if(!responce.IsSuccess())
		return(-1);

	//	擾
	context.Copy(responce.GetAttachedDataAccess());
	return(0);
}

//////////////////////////////////////////////////////////////////////////////////
//	I[o[[h
//////////////////////////////////////////////////////////////////////////////////
/*!
	ڑbZ[WM
*/
int CServerControlInterface2::OnWelcome(CBuffer &recv)
{
	//	bZ[WmF
	CCommandPacket	packet;
	if(packet.FromBuffer(recv))
		return(-1);

	//	T[omF
	if(	packet.GetCommand() != _T("Welcome") ||
		packet.GetCommandOption(_T("SupportedInterface")).Find(_T(REQUEST_CONTROL_INTERFACE)) == -1)
		return(-1);

	return(0);
}

//////////////////////////////////////////////////////////////////////////////////
//	c[
//////////////////////////////////////////////////////////////////////////////////
/*!
	R}h𑗂
*/
int CServerControlInterface2::SendCommandPacket(CCommandPacket &sendCommand, CCommandPacket &recvCommand)
{
	CBuffer	send, recv;
	sendCommand.ToBuffer(send);

	//	M
	if(SendCommand(send, recv))
	{
		//	ēxJĂ݂
		if(OpenServerControl())
			return(-1);

		//	R}hđM
		if(SendCommand(send, recv))
			return(-1);
	}

	//	MpPbg
	if(recvCommand.FromBuffer(recv))
		return(-1);
	return(0);
}


