// ServerPage1.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "ServerPage1.h"


// CServerPage1 _CAO

IMPLEMENT_DYNAMIC(CServerPage1, CPropertyPage)
CServerPage1::CServerPage1()
	: CPropertyPage(CServerPage1::IDD)
	, m_port(10)
	, m_maxConnect(10)
	, m_timeOut(10)
	, m_hostConnect(10)
	, m_keepAliveEnable(FALSE)
	, m_keepAliveMax(10)
	, m_keepAliveTime(10)
{
}

CServerPage1::~CServerPage1()
{
}

void CServerPage1::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_PORT, m_port);
	DDV_MinMaxUInt(pDX, m_port, 1, 65535);
	DDX_Text(pDX, IDC_MAX_CONNECT, m_maxConnect);
	DDV_MinMaxUInt(pDX, m_maxConnect, 0, 65535);
	DDX_Text(pDX, IDC_TIME_OUT, m_timeOut);
	DDV_MinMaxUInt(pDX, m_timeOut, 5, 65535);
	DDX_Text(pDX, IDC_MAX_HOST, m_hostConnect);
	DDV_MinMaxUInt(pDX, m_hostConnect, 0, 65535);
	DDX_Check(pDX, IDC_KEEP_ALIVE_ENABLE, m_keepAliveEnable);
	DDX_Text(pDX, IDC_KEEP_ALIVE_MAX, m_keepAliveMax);
	DDV_MinMaxUInt(pDX, m_keepAliveMax, 1, 65535);
	DDX_Text(pDX, IDC_KEEP_ALIVE_TIMEOUT, m_keepAliveTime);
	DDV_MinMaxUInt(pDX, m_keepAliveTime, 1, 65535);
}


BEGIN_MESSAGE_MAP(CServerPage1, CPropertyPage)
END_MESSAGE_MAP()


// CServerPage1 bZ[W nh

BOOL CServerPage1::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	CWorkspaceAccess	setting = GET_APP()->m_setting.GetAccess("Basic");

	m_port = setting.GetConfig("Port",80);
	m_maxConnect = setting.GetConfig("MaxConnect",50);
	m_timeOut = setting.GetConfig("TimeOut",300);
	m_keepAliveEnable = setting.GetConfig("EnableKeepAlive",1);
	m_keepAliveMax = setting.GetConfig("MaxKeepAlive",5);
	m_keepAliveTime = setting.GetConfig("KeepAliveTime",20);
	m_hostConnect = GET_APP()->m_setting.GetConfig("Basic::MaxOneHostConnect",0);

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

BOOL CServerPage1::OnKillActive()
{
	// TODO : ɓȃR[hǉ邩A͊{NXĂяoĂB
	CWorkspaceAccess	setting = GET_APP()->m_setting.GetAccess("Basic");

	UpdateData(TRUE);
	setting.SetConfig("Port",m_port);
	setting.SetConfig("MaxConnect",m_maxConnect);
	setting.SetConfig("TimeOut",m_timeOut);
	setting.SetConfig("EnableKeepAlive",m_keepAliveEnable);
	setting.SetConfig("MaxKeepAlive",m_keepAliveMax);
	setting.SetConfig("KeepAliveTime",m_keepAliveTime);
	GET_APP()->m_setting.SetConfig("Basic::MaxOneHostConnect",m_hostConnect);

	return CPropertyPage::OnKillActive();
}
