#include "StdAfx.h"
#include "WorkspaceXMLWriter.h"
#include "TextTools.h"
#include "TypedBuffer.h"

CWorkspaceXMLWriter::CWorkspaceXMLWriter(void)
{
}

CWorkspaceXMLWriter::~CWorkspaceXMLWriter(void)
{
}

//!	XMLo(throw CWorkspaceXMLWriterException)
CStringA CWorkspaceXMLWriter::ToString(CWorkspaceNode *root, CString workspaceClassType)
{
	m_xml.Empty();
	m_workspaceClassType = workspaceClassType;

	//	wb_o
	WriteHeader();

	//	f[^o
	WriteSubNode(root, "\t");

	//	tb^o
	WriteFooter();

	return m_xml;
}

/*!
	t@C֏o
*/
void CWorkspaceXMLWriter::SaveToFile(CWorkspaceNode *root, CString path, CString workspaceClassType)
{
	m_xml.Empty();
	m_workspaceClassType = workspaceClassType;

	//	wb_o
	WriteHeader();

	//	f[^o
	WriteSubNode(root, "\t");

	//	tb^o
	WriteFooter();

	//	UTF16֕ϊ
	CStringW			utf16(m_xml);

	//	UTF8֕ϊ
	int mbLen = WideCharToMultiByte(CP_UTF8, 0, utf16.GetBuffer(0), utf16.GetLength(), NULL, 0, NULL, NULL);
	CTypedBuffer<char>	utf8(mbLen);
	WideCharToMultiByte(CP_UTF8, 0, utf16.GetBuffer(0), utf16.GetLength(), utf8.GetPtr(), utf8.GetCount(), NULL, NULL);

	//	J
	FILE	*out;
	if(_tfopen_s(&out, path, _T("wb")) != 0)
		throw CWorkspaceXMLWriterException(_T("t@C̃I[vɎs܂"));

	fwrite(utf8.GetPtr(), mbLen, 1, out);
	fclose(out);
}


/////////////////////////////////////////////////////////////////////////////
//	o͊֐
/////////////////////////////////////////////////////////////////////////////
/*!
	wb_[o
*/
void CWorkspaceXMLWriter::WriteHeader()
{
	m_xml += CTextTools::GetFormat(_T("<?xml version=\"1.0\"?>\r\n<!--Soft3304 CWorkspace class.-->\r\n<CWorkspaceClass type=\"%s\">\r\n"), m_workspaceClassType, m_workspaceClassType);
}

/*!
	tb^[o
*/
void CWorkspaceXMLWriter::WriteFooter()
{
	m_xml += CString(_T("</CWorkspaceClass>\r\n"));
}


/*!
	Pm[ho
*/
void CWorkspaceXMLWriter::WriteSubNode(CWorkspaceNode *node, CString tab)
{
	//	o
	m_xml += CTextTools::GetFormat(_T("%s<Subnode name=\"%s\">\r\n"), tab, node->GetNodeName());

	//	L[o
	for(int i=0;;i++)
	{
		CKeyData *key = node->GetKeyByIndex(i);
		if(key == NULL)
			break;

		//	ϊ
		CTextEscape	escape;
		escape.AddEscape(_T("<"), _T("&lt;"));
		escape.AddEscape(_T(">"), _T("&gt;"));
		escape.AddEscape(_T("&"), _T("&amp;"));
		CString data = escape.Escape(key->m_data);


		//	o
		m_xml += CTextTools::GetFormat(_T("%s\t<Key name=\"%s\">%s</Key>\r\n"), tab, key->m_key, data);
	}

	//	Tum[ho
	for(int i=0;;i++)
	{
		CWorkspaceNode *subnode = node->GetSubNodeByIndex(i);
		if(subnode == NULL)
			break;

		//	o
		WriteSubNode(subnode, tab + "\t");
	}

	//	
	m_xml += CTextTools::GetFormat(_T("%s</Subnode>\r\n"), tab);
}
