#include "StdAfx.h"
#include "CommandPacket.h"
#include "TextTools.h"



CCommandPacket::CCommandPacket(void)
{
	m_xmlRootAccess = m_xmlRoot.GetAccess("");
	m_xmlBasicData = m_xmlRoot.GetAccess("Basic");
	m_xmlAttachedData = m_xmlRoot.GetAccess("Attached");
}

CCommandPacket::CCommandPacket(CCommandPacket &other)
{
	m_xmlRootAccess = m_xmlRoot.GetAccess("");
	m_xmlBasicData = m_xmlRoot.GetAccess("Basic");
	m_xmlAttachedData = m_xmlRoot.GetAccess("Attached");

	m_xmlRootAccess.Copy(other.m_xmlRootAccess);
}

void CCommandPacket::operator=(CCommandPacket &other)
{
	m_xmlRootAccess.Copy(other.m_xmlRootAccess);
}

CCommandPacket::~CCommandPacket(void)
{
}



////////////////////////////////////////////////////////////////////////////////////
//	ϊ
////////////////////////////////////////////////////////////////////////////////////
/*!
	obt@f[^\z
*/
int CCommandPacket::FromBuffer(CBuffer &data)
{
	m_xmlRootAccess.Clear();

	//	TCY0?
	if(data.GetSize() == 0)
		return(-1);

	//	[hĂ݂
	if(m_xmlRoot.FromXMLStringUTF8(data))
		return(-1);

	//	R}hƃG[
	if(GetCommand().IsEmpty())
		return(-1);

	return(0);
}


/*!
	obt@f[^֕ϊ
*/
void CCommandPacket::ToBuffer(CBuffer &data)
{
	//	ϊ
	data.ReSize(0);
	data += m_xmlRoot.ToXMLStringUTF8();
}

////////////////////////////////////////////////////////////////////////////////////
//	{̐ݒ
////////////////////////////////////////////////////////////////////////////////////
/*!
	R}hݒ
*/
void CCommandPacket::SetCommand(CString command)
{
	SetCommandOption("Command", command);
}

/*!
	R}h擾
*/
CString CCommandPacket::GetCommand()
{
	return(GetCommandOption("Command"));
}

/*!
	IvVڂ̐ݒ
*/
void CCommandPacket::SetCommandOption(CString key, CString data)
{
	m_xmlBasicData.SetKeyStr(key, data);
}

/*!
	IvVڂ̐ݒ
*/
void CCommandPacket::SetCommandOptionInt(CString key, int data)
{
	m_xmlBasicData.SetKeyInt(key, data);
}

/*!
	IvVڂ̎擾
*/
CString CCommandPacket::GetCommandOption(CString key, CString data)
{
	return(m_xmlBasicData.GetKeyStr(key, data));
}


/*!
	IvVڂ̎擾
*/
int CCommandPacket::GetCommandOptionInt(CString key, int data)
{
	return(m_xmlBasicData.GetKeyInt(key, data));
}


////////////////////////////////////////////////////////////////////////////////////
//	܂Ƃ߂ďݒ
////////////////////////////////////////////////////////////////////////////////////
/*!
	I
*/
void CCommandPacket::SetSuccessPacket()
{
	SetCommand(_T("Success"));
}

/*!
	G[
*/
void CCommandPacket::SetErrorPacket(int errorCode, CString errorInfo)
{
	SetCommand(_T("Error"));
	SetCommandOptionInt(_T("ErrorCode"), errorCode);
	SetCommandOption(_T("ErrorInfo"), errorInfo);
}

////////////////////////////////////////////////////////////////////////////////////
//	`FbN
////////////////////////////////////////////////////////////////////////////////////
/*!
	H
*/
int CCommandPacket::IsSuccess()
{
	if(GetCommand() == _T("Success"))
		return(TRUE);
	return(FALSE);
}