#include "StdAfx.h"
#include "CommandPipe.h"
#include "CommandPacket.h"

#define	PACKET_READ_SIZE	(256 * 1024)

CCommandPipe::CCommandPipe(void)
{
	m_hPipe = NULL;
}

CCommandPipe::~CCommandPipe(void)
{
	Close();
}

//////////////////////////////////////////////////////////////////////////////////
//	JnE~
//////////////////////////////////////////////////////////////////////////////////
/*!
	Jn
*/
int CCommandPipe::Connect(CString pipeName)
{
	if(pipeName.Left(2) != "\\\\")
		pipeName = "\\\\.\\pipe\\" + pipeName;

	//	J
	m_hPipe = ::CreateFile (pipeName,	GENERIC_READ | GENERIC_WRITE, 0, NULL,
							OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if(m_hPipe == INVALID_HANDLE_VALUE)
		return(-1);

	//	EFJbZ[W҂
	CBuffer	welcome;
	if(RecvData(welcome))
		return(-1);

	//	bZ[WmF
	if(OnWelcome(welcome))
		return(-1);

	return(0);
}


/*!
	R}h𑗂
*/
int CCommandPipe::SendCommand(CBuffer &send, CBuffer &recv)
{
	//	M
	if(SendData(send))
		return(-1);

	//	M
	if(RecvData(recv))
		return(-1);

	return(0);
}


/*!
	
*/
void CCommandPipe::Close()
{
	SAFE_CLOSE_HANDLE(m_hPipe);
}


/*!
	ؒfmF
*/
int CCommandPipe::CheckDisconnect()
{
	if(m_hPipe == NULL)
		return(1);

	if(!PeekNamedPipe(m_hPipe, NULL,0,NULL,NULL,NULL))
	{
		Close();
		return(1);
	}

	return(0);
}



//////////////////////////////////////////////////////////////////////////////////
//	M
//////////////////////////////////////////////////////////////////////////////////
/*!
	M
*/
int CCommandPipe::SendData(CBuffer &sendData)
{
	DWORD	sendLen;

	//	M
	if(!WriteFile(m_hPipe, sendData.GetPtr(), sendData.GetSize(), &sendLen, NULL))
	{
		Close();
		return(-1);
	}
	return(0);
}

/*!
	M
*/
int CCommandPipe::RecvData(CBuffer &recvData)
{
	DWORD	recvLen;

	//	M
	int	recved = 0, bufSize = PACKET_READ_SIZE;
	while(1)
	{
		//	ǂݍ
		recvData.ReSize(bufSize);
		if(!ReadFile(m_hPipe, recvData.GetPtr() + recved, bufSize, &recvLen, NULL))
		{
			//	c肪H
			if(::GetLastError() == ERROR_MORE_DATA)
			{
				recved += recvLen;
				bufSize *= 2;
				continue;
			}
			else
			{
				Close();
				return(-1);
			}
		}
		break;
	}
	recvData.ReSize(recved + recvLen);

	return(0);
}
