// FileSelectDialog.cpp: CFileSelectDialog NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Buffer.h"
#include "FileSelectDialog.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CFileSelectDialog::CFileSelectDialog(HWND owner,CString defaultName)
{
	memset(&m_ofn,0,sizeof(m_ofn));

	m_ofn.lStructSize = sizeof(m_ofn);
	m_ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	m_ofn.hwndOwner = owner;
	m_ofn.nFilterIndex = 1;
	m_ofn.lpstrFile = m_nameBuf;
	m_ofn.nMaxFile = MAX_PATH + 1;
	m_ofn.lpstrDefExt = NULL;
	strcpy_s(m_nameBuf, sizeof(m_nameBuf), defaultName);
}

CFileSelectDialog::~CFileSelectDialog()
{

}

void CFileSelectDialog::SetFlag(int flag)
{
	m_ofn.Flags = flag;
}

int CFileSelectDialog::OpenFile(CString title)
{
	m_ofn.lpstrTitle = title;

	CBuffer	filter(0);
	if(m_filter.GetSize())
	{
		for(int	i=0;i<m_filter.GetSize();i++)
		{
			filter+=m_info[i];
			filter+='\0';
			filter+=m_filter[i];
			filter+='\0';
		}
	}
	else
	{
		filter+="All Files(*.*)\0*.*";
		filter+='\0';
	}
	filter+='\0';
	m_ofn.lpstrFilter = filter;

	if(GetOpenFileName(&m_ofn))
		return(IDOK);
	return(IDCANCEL);
}

CString CFileSelectDialog::GetFilePath()
{
	return(m_nameBuf);
}

void CFileSelectDialog::AddExt(CString ext, CString info)
{
	m_info.Add(info);
	m_filter.Add(ext);
}
