// FolderDialog.cpp: CFolderDialog NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
//#include "MyClass.h"
#include "FolderDialog.h"
#include <shlobj.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
CFolderDialog::~CFolderDialog()
{

}

BOOL CFolderDialog::DoModal()
{
	//錾
	BOOL fRes=FALSE;
	BROWSEINFO bi;
	LPTSTR lpBuffer;
	LPITEMIDLIST pidlRootFolders;
	LPITEMIDLIST pidlBrowse;
	LPITEMIDLIST pidlDefault=0;
	IMalloc* g_pMalloc;
	SHGetMalloc(&g_pMalloc);

	//ȒlȂ֐o
	if((lpBuffer=(LPTSTR)g_pMalloc->Alloc(MAX_PATH)) == NULL)
		return fRes;
	if (!SUCCEEDED(SHGetSpecialFolderLocation(m_parentHWnd,CSIDL_DESKTOP,&pidlRootFolders)))
	{
		g_pMalloc->Free(lpBuffer);
		return fRes;
	}

	//ftHg̃tH_w肳Ă邩ǂ
	if(m_defaulFolder!=_T(""))
		pidlDefault=GetItemIDList(m_defaulFolder);

	//\z
	bi.hwndOwner=m_parentHWnd;
	bi.pidlRoot=pidlRootFolders;
	bi.pszDisplayName=lpBuffer;
	bi.lpszTitle=m_display;
	bi.ulFlags=BIF_RETURNONLYFSDIRS;
	bi.lpfn=(BFFCALLBACK)BrowseCallbackProc;
	bi.lParam=(LPARAM)pidlDefault;

	//ۂɕ\
	pidlBrowse=SHBrowseForFolder(&bi);

	//f[^擾
	if(pidlBrowse!=NULL)
	{
		if(SHGetPathFromIDList(pidlBrowse,lpBuffer))
		{
			m_selectedFolder.Format(_T("%s"),lpBuffer);
			fRes=TRUE;
		}
		g_pMalloc->Free(pidlBrowse);
	}

	//n
	g_pMalloc->Free(pidlRootFolders);
	g_pMalloc->Free(lpBuffer);
	g_pMalloc->Free(pidlDefault);

	return fRes;
}

LPITEMIDLIST CFolderDialog::GetItemIDList(CString p_cFileStr)
{
	//ȒlȂ֐o
	if( p_cFileStr.IsEmpty())
		return NULL;

	//錾
	LPITEMIDLIST pIDL;
	LPSHELLFOLDER pDesktopFolder; 

	//Ȃ֐o
	if( ::SHGetDesktopFolder( &pDesktopFolder ) != NOERROR )
		return NULL;

#ifdef _UNICODE
	ULONG chEaten;	//̃TCY󂯎܂B
	ULONG dwAttributes;	//󂯎܂B
	HRESULT hRes;

	//ۂITEMIDLIST擾
	hRes = pDesktopFolder->ParseDisplayName( NULL, NULL, p_cFileStr.GetBuffer(MAX_PATH + 1), &chEaten, &pIDL, &dwAttributes);
#else
	//錾
	OLECHAR ochPath[MAX_PATH];
	ULONG chEaten;	//̃TCY󂯎܂B
	ULONG dwAttributes;	//󂯎܂B
	HRESULT hRes;

	//̕ϊ
	::MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED, p_cFileStr, -1, ochPath, MAX_PATH );

	//ۂITEMIDLIST擾
	hRes = pDesktopFolder->ParseDisplayName( NULL, NULL, ochPath, &chEaten, &pIDL, &dwAttributes);
#endif
	
	//G[o֐o
	if( hRes != NOERROR )
		pIDL = NULL;
	
	//n
	pDesktopFolder->Release();

	return pIDL;

}

int AFXAPI CFolderDialog::BrowseCallbackProc(HWND hwnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
{
	//@ɃtH_I܂B
	if( uMsg == BFFM_INITIALIZED )	
	{
//		::SetWindowText(hwnd,_T("tH_̎Q"));
		::SetWindowText(hwnd,_T("Selecct Folder..."));
		::SendMessage(hwnd,BFFM_SETSELECTION,FALSE,lpData);
	}
	else
	{
		TCHAR chText[MAX_PATH];
		if(::SHGetPathFromIDList((LPITEMIDLIST)lParam,chText))
		::SendMessage(hwnd,BFFM_SETSTATUSTEXT,TRUE,(LPARAM)chText);
	}
	return 0;
}

CString CFolderDialog::GetFolderPath()
{
	CString	ret = m_selectedFolder;
	if(ret.Right(1) != "\\")
		ret += "\\";
	return(ret);
}