// MainFrm.cpp : CMainFrame NX̎
//

#include "stdafx.h"
#include "ServerController.h"

#include "MainFrm.h"
#include "TextTools.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_WM_TIMER()
	ON_WM_SIZE()
	ON_WM_DESTROY()
	ON_MESSAGE( WM_USER_NTFYICON, OnTrayIcon )
	ON_COMMAND(ID_TASKTRAY_RESTORE, OnTasktrayRestore)
	ON_COMMAND(ID_TASKTRAY_CANSEL, OnTasktrayCansel)
	ON_WM_MOVE()
	ON_WM_CLOSE()
END_MESSAGE_MAP()

// CMainFrame RXgNV/fXgNV

CMainFrame::CMainFrame()
{
	m_oldConnect = 0;
	m_trayIconId = 0;
	m_autoClose = 0;
	m_quitMessage = -1;
}

CMainFrame::~CMainFrame()
{
}


int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	//	pt[쐬
	if (!m_secndFrame.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
		CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
	{
		TRACE0("r[ EBhE쐬ł܂łB\n");
		return -1;
	}

	//	c[o[쐬
	if (!m_wndToolBar.CreateEx(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("c[o[̍쐬Ɏs܂B\n");
		return -1;      // 쐬ł܂łB
	}

	//	̐ݒ
	int		i,id,tindex,maxIndex = m_wndToolBar.GetCount();
	CString	str;

	for(i=0;i<maxIndex;i++)
	{
		id = m_wndToolBar.GetItemID(i);

		if(id != ID_SEPARATOR)
		{
			str.LoadString(id);
			tindex = str.Find("\n");
			str = str.Mid(tindex + 1);
			m_wndToolBar.SetButtonText(i,str);
		}
	}

	//	CAEgύX
	CRect rcButton;
	m_wndToolBar.GetItemRect(0, rcButton);
	m_wndToolBar.SetSizes(CSize(rcButton.Width(), rcButton.Height()), CSize(16, 16));
	ShowControlBar(&m_wndToolBar, TRUE, FALSE);
	RecalcLayout();

	//	ReBar쐬
	if (!m_wndReBar.Create(this) ||
		!m_wndReBar.AddBar(&m_wndToolBar))
	{
		TRACE0("rebar ̍쐬Ɏs܂B\n");
		return -1;      // 쐬ł܂łB
	}

	if (!m_wndStatusBar.Create(this))
	{
		TRACE0("Xe[^X o[̍쐬Ɏs܂B\n");
		return -1;      // 쐬ł܂łB
	}

	// TODO: c[ qg\Ȃꍇ́A폜ĂB
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY);



	//	ACR̐ݒ
//	SetIcon(AfxGetApp()->LoadIcon(IDI_APP),0);
	SetIcon(AfxGetApp()->LoadIcon(IDI_APP),1);

	//	Oݒ
	SetWindowText("04WebServer - ServerController");

	AddTrayIcon();
	SetTimer(512,500,NULL);

	//	IbZ[Wo^
	m_quitMessage = ::RegisterWindowMessage(_T("04WebServer All Quit"));

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;

	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass(0);
	return TRUE;
}


// CMainFrame ff

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG


// CMainFrame bZ[W nh

void CMainFrame::OnSetFocus(CWnd* /*pOldWnd*/)
{
	m_secndFrame.SetFocus();
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	if (m_secndFrame.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;

	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

//	EChȄԂۑ
void CMainFrame::PushWindowStat()
{
	//	TCYۑ
	WINDOWPLACEMENT	status;
	status.length = sizeof(WINDOWPLACEMENT);
	GetWindowPlacement(&status);

	CRect	window = status.rcNormalPosition;
	AfxGetApp()->WriteProfileInt("WindowStat","left",window.left);
	AfxGetApp()->WriteProfileInt("WindowStat","right",window.right);
	AfxGetApp()->WriteProfileInt("WindowStat","top",window.top);
	AfxGetApp()->WriteProfileInt("WindowStat","bottom",window.bottom);

	AfxGetApp()->WriteProfileInt("WindowStat","maxLeft",status.ptMaxPosition.x);
	AfxGetApp()->WriteProfileInt("WindowStat","maxTop",status.ptMaxPosition.y);

	AfxGetApp()->WriteProfileInt("WindowStat","minLeft",status.ptMinPosition.x);
	AfxGetApp()->WriteProfileInt("WindowStat","minTop",status.ptMinPosition.y);

	AfxGetApp()->WriteProfileInt("WindowStat","Saved",1);
}

//	EChȄԂ𕜋A
void CMainFrame::PopWindowStat()
{
	//	ʒu̕A
	if(AfxGetApp()->GetProfileInt("WindowStat","Saved",0))
	{
		WINDOWPLACEMENT	winStat;
		winStat.length = sizeof(WINDOWPLACEMENT);
		winStat.flags = WPF_SETMINPOSITION;
		winStat.showCmd = SW_HIDE;
		winStat.rcNormalPosition.left = AfxGetApp()->GetProfileInt("WindowStat","left",10);
		winStat.rcNormalPosition.right = AfxGetApp()->GetProfileInt("WindowStat","right",600);
		winStat.rcNormalPosition.top = AfxGetApp()->GetProfileInt("WindowStat","top",10);
		winStat.rcNormalPosition.bottom = AfxGetApp()->GetProfileInt("WindowStat","bottom",400);
		winStat.ptMaxPosition.x = AfxGetApp()->GetProfileInt("WindowStat","maxLeft",0);
		winStat.ptMaxPosition.y = AfxGetApp()->GetProfileInt("WindowStat","maxTop",0);
		winStat.ptMinPosition.x = AfxGetApp()->GetProfileInt("WindowStat","minLeft",0);
		winStat.ptMinPosition.y = AfxGetApp()->GetProfileInt("WindowStat","minTop",0);
		SetWindowPlacement(&winStat);
		

		//	ŏH
		if(AfxGetApp()->GetProfileInt("WindowStat","Iconic",0))
		{
/*			if(AfxGetApp()->GetProfileInt("WindowStat","Zoomed",0))
			{
				winStat.flags = WPF_RESTORETOMAXIMIZED;
				winStat.showCmd = SW_SHOWMINIMIZED;
				SetWindowPlacement(&winStat);
			}
			else
			{
				ShowWindow(SW_MINIMIZE);
			}
*/
			TRACE(_T("ŏ\n"));
			ShowWindow(SW_HIDE);
		}
		else
		{
			if(AfxGetApp()->GetProfileInt("WindowStat","Zoomed",0))
				ShowWindow(SW_SHOWMAXIMIZED);
			else
				ShowWindow(SW_SHOW);
		}
	}
	else
	{
		ShowWindow(SW_SHOW);
	}
}


/////////////////////////////////////////////////////////////////////////////
// ^XNgCACR
/////////////////////////////////////////////////////////////////////////////
//	ǉ
void CMainFrame::AddTrayIcon()
{

	//	^XNgCɒǉ
	NOTIFYICONDATA	trayIcon;
	trayIcon.cbSize = sizeof( NOTIFYICONDATA );
	trayIcon.uID = 0;
	trayIcon.hWnd = m_hWnd;
	trayIcon.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
	trayIcon.hIcon = GET_APP()->LoadIcon(MAKEINTRESOURCE(IDI_TRAY1));

	trayIcon.uCallbackMessage = WM_USER_NTFYICON;
	GetWindowText(trayIcon.szTip,sizeof(trayIcon.szTip));
	::Shell_NotifyIcon( NIM_ADD, &trayIcon );

	m_trayIconId = IDI_TRAY1;
	m_explorerMessage = ::RegisterWindowMessage(_T("TaskbarCreated"));

	SetTaryIcon(IDI_TRAY1,"04WebServer - 0 ڑ");
}


//	폜
void CMainFrame::DelTrayIcon()
{
	NOTIFYICONDATA	trayIcon;

	memset(&trayIcon,0,sizeof( NOTIFYICONDATA ));
	trayIcon.cbSize = sizeof( NOTIFYICONDATA );
	trayIcon.hWnd = m_hWnd;
	trayIcon.uCallbackMessage = WM_USER_NTFYICON;
	::Shell_NotifyIcon( NIM_DELETE, &trayIcon);
}

//	GNXv[S΍
LRESULT CMainFrame::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message == m_explorerMessage)
		AddTrayIcon();
	
	if(message == m_quitMessage)
	{
		m_autoClose = 1;
		PostMessage(WM_CLOSE);
	}

	return CFrameWnd::WindowProc(message, wParam, lParam);
}

//	^XNgCbZ[W
LRESULT CMainFrame::OnTrayIcon(WPARAM wParam, LPARAM lParam)
{
	switch( lParam )
	{
		case WM_RBUTTONDOWN:
			TrayMenu();
			break;

		case WM_LBUTTONDOWN:
			OnTasktrayRestore();
			break;
	}

	return 0;
}


//	^C}
void CMainFrame::OnTimer(UINT nIDEvent) 
{
	int count = GET_APP()->m_serverControl.GetConnectionCount();

	if(m_oldConnect != count)
	{
		CString	str;
		str.Format("04WebServer - %d ڑ",count);

		if(count)
			SetTaryIcon(IDI_TRAY2,str);
		else
			SetTaryIcon(IDI_TRAY1,str);

		m_oldConnect = count;
	}
	
	CFrameWnd::OnTimer(nIDEvent);
}

//	ACRύX
void CMainFrame::SetTaryIcon(int id,CString message)
{
	if(message.IsEmpty())
		GetWindowText(message);

	NOTIFYICONDATA	trayIcon;
	trayIcon.uFlags = NIF_MESSAGE | NIF_TIP;

	if(m_trayIconId != id)
		trayIcon.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
	else
		trayIcon.uFlags = NIF_MESSAGE | NIF_TIP;

	trayIcon.cbSize = sizeof( NOTIFYICONDATA );
	trayIcon.uID = 0;
	trayIcon.hWnd = m_hWnd;
	trayIcon.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP;
	trayIcon.hIcon = GET_APP()->LoadIcon(MAKEINTRESOURCE(id));

	trayIcon.uCallbackMessage = WM_USER_NTFYICON;
	strncpy_s( trayIcon.szTip, sizeof(trayIcon.szTip), message, sizeof(trayIcon.szTip));
	::Shell_NotifyIcon( NIM_MODIFY, &trayIcon );

	m_trayIconId = id;
}

//	TCYύX
void CMainFrame::OnSize(UINT nType, int cx, int cy)
{
	if(nType == SIZE_MINIMIZED)
	{
		AfxGetApp()->WriteProfileInt("WindowStat","Iconic",1);
		ShowWindow(SW_HIDE);
	}
	else if(nType == SIZE_MAXIMIZED)
	{
		AfxGetApp()->WriteProfileInt("WindowStat","Zoomed",1);
		AfxGetApp()->WriteProfileInt("WindowStat","Iconic",0);
		ShowWindow(SW_SHOW);
	}
	else if(nType == SIZE_RESTORED)
	{
		ShowWindow(SW_SHOW);
		AfxGetApp()->WriteProfileInt("WindowStat","Zoomed",0);
		AfxGetApp()->WriteProfileInt("WindowStat","Iconic",0);
	}

	CFrameWnd::OnSize(nType, cx, cy);
}

//	ړ
void CMainFrame::OnMove(int x, int y)
{
	CFrameWnd::OnMove(x, y);

	if(IsWindowVisible())
		PushWindowStat();
}

//	
void CMainFrame::OnDestroy()
{
	CFrameWnd::OnDestroy();

	PushWindowStat();
	DelTrayIcon();
}


//	^XNgCj[
void CMainFrame::TrayMenu()
{
	CMenu	menu,*menu2;
	CPoint	pt;

	GetCursorPos(&pt);

	menu.LoadMenu(IDR_TASK_TRAY);
	menu2 = menu.GetSubMenu(0);
	menu2->SetDefaultItem(ID_TASKTRAY_RESTORE);

	//	j[\
	SetForegroundWindow();
	menu2->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, pt.x, pt.y, this);
	PostMessage(WM_NULL, 0, 0);
}

//	̃TCYɖ߂
void CMainFrame::OnTasktrayRestore()
{
	if(AfxGetApp()->GetProfileInt("WindowStat","Zoomed",0))
		ShowWindow(SW_SHOWMAXIMIZED);
	else
		ShowWindow(SW_SHOW);

	if(IsIconic())
		OpenIcon();

	SetActiveWindow();
}

//	Ȃ
void CMainFrame::OnTasktrayCansel()
{
}


void CMainFrame::OnClose()
{
	//	AvP[V[hł͌x
	if(!GET_APP()->m_serverControl.IsService() && m_autoClose == 0)
	{
		if(MessageBox("T[oRg[IƃT[o~܂B\r\nIĂ낵łH","T[o[~",MB_OKCANCEL | MB_ICONQUESTION) == IDCANCEL)
			return;
	}

	CFrameWnd::OnClose();
}
