// PathPage1.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "PathPage1.h"
#include "FolderDialog.h"


// CPathPage1 _CAO

IMPLEMENT_DYNAMIC(CPathPage1, CPropertyPage)
CPathPage1::CPathPage1(CWorkspaceAccess path)
	: CPropertyPage(CPathPage1::IDD)
	, m_info(_T(""))
	, m_serverPath(_T(""))
	, m_localPath(_T(""))
	, m_forward(_T(""))
	, m_enableVH(FALSE)
{
	m_pathSetting = path;
}

CPathPage1::~CPathPage1()
{
}

void CPathPage1::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_INFO, m_info);
	DDX_Text(pDX, IDC_SERVER_PATH, m_serverPath);
	DDX_Text(pDX, IDC_LOCAL_PATH, m_localPath);
	DDX_Text(pDX, IDC_FORWARD, m_forward);
	DDX_Check(pDX, IDC_ENABLE_VH, m_enableVH);
	DDX_Control(pDX, IDC_VH_NAME, m_vhName);
}


BEGIN_MESSAGE_MAP(CPathPage1, CPropertyPage)
	ON_BN_CLICKED(IDC_BROWS, OnBnClickedBrows)
	ON_BN_CLICKED(IDC_ENABLE_VH, OnBnClickedEnableVh)
END_MESSAGE_MAP()


// CPathPage1 bZ[W nh

BOOL CPathPage1::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	m_info = m_pathSetting.GetConfig("Info","");
	m_serverPath = m_pathSetting.GetConfig("ServerPath","");
	m_localPath = m_pathSetting.GetConfig("LocalPath","");
	m_forward = m_pathSetting.GetConfig("Forward","");

	CString vh = m_pathSetting.GetConfig("VirtualHost","*");

	if(vh == "*")
		m_enableVH = FALSE;
	else
		m_enableVH = TRUE;

	m_vhName.SetWindowText(vh);
	if(m_enableVH)
		m_vhName.EnableWindow(TRUE);
	else
		m_vhName.EnableWindow(FALSE);

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CPathPage1::OnBnClickedBrows()
{
	UpdateData();
	CFolderDialog	sel;
	sel.SetDefaultFolder(m_localPath);

	if(sel.DoModal()==IDOK)
	{
		m_localPath = sel.GetFolderPath();
		UpdateData(FALSE);
	}
}

BOOL CPathPage1::OnKillActive()
{
	UpdateData();
	CString vh;
	m_vhName.GetWindowText(vh);

	if(m_info.IsEmpty() || m_serverPath.IsEmpty() || (m_localPath.IsEmpty() && m_forward.IsEmpty() && vh.IsEmpty()))
	{
		MessageBox("͂̍ڂ܂B");
		return(FALSE);
	}

	if(m_serverPath.Right(1) != "/")
		m_serverPath += "/";

	if(m_serverPath.Left(1) != "/")
		m_serverPath = "/" + m_serverPath;

	if(m_localPath.Right(1) != "\\" && !m_localPath.IsEmpty())
		m_localPath += "\\";


	m_pathSetting.SetConfig("Info",m_info);
	m_pathSetting.SetConfig("ServerPath",m_serverPath);
	m_pathSetting.SetConfig("LocalPath",m_localPath);
	m_pathSetting.SetConfig("Forward",m_forward);
	m_pathSetting.SetConfig("VirtualHost",vh);



	return CPropertyPage::OnKillActive();
}

void CPathPage1::OnBnClickedEnableVh()
{
	UpdateData();

	if(m_enableVH)
		m_vhName.EnableWindow(TRUE);
	else
		m_vhName.EnableWindow(FALSE);
}
