// PathPage2.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "PathPage2.h"


// CPathPage2 _CAO

IMPLEMENT_DYNAMIC(CPathPage2, CPropertyPage)
CPathPage2::CPathPage2(CWorkspaceAccess path)
	: CPropertyPage(CPathPage2::IDD)
	, m_index(FALSE)
	, m_webdav(FALSE)
	, m_ssicgi(FALSE)
	, m_bandwidth(FALSE)
	, m_write(FALSE)
	, m_hidden(FALSE)
	, m_http(FALSE)
	, m_https(FALSE)
{
	m_pathOptions = path.GetAccess("Options");;
}

CPathPage2::~CPathPage2()
{
}

void CPathPage2::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_INDEX, m_index);
	DDX_Check(pDX, IDC_WEBDAV, m_webdav);
	DDX_Check(pDX, IDC_SSICGI, m_ssicgi);
	DDX_Check(pDX, IDC_BAND, m_bandwidth);
	DDX_Check(pDX, IDC_WRITE, m_write);
	DDX_Check(pDX, IDC_HIDDEN, m_hidden);
	DDX_Check(pDX, IDC_HTTP, m_http);
	DDX_Check(pDX, IDC_HTTPS, m_https);
}


BEGIN_MESSAGE_MAP(CPathPage2, CPropertyPage)
END_MESSAGE_MAP()


// CPathPage2 bZ[W nh

BOOL CPathPage2::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	m_index = m_pathOptions.GetConfig("EnableIndex",1);
	m_webdav = m_pathOptions.GetConfig("EnableWebDAV",0);
	m_ssicgi = m_pathOptions.GetConfig("EnableSSICGI",0);
	m_bandwidth = m_pathOptions.GetConfig("EnableBandWidthLimit",0);
	m_write = m_pathOptions.GetConfig("EnableWrite",0);
	m_hidden = m_pathOptions.GetConfig("EnableHiddenFile",0);

	m_http = m_pathOptions.GetConfig("AcceptHTTP",1);
	m_https = m_pathOptions.GetConfig("AcceptHTTPS",1);

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

BOOL CPathPage2::OnKillActive()
{
	UpdateData();

	//	ZLeB@`FbN
	if(m_write && m_ssicgi)
	{
		if(MessageBox("uSSI/CGIvƁu݂v̑gݍ킹́AZLeBAɍD܂܂B\r\ns܂H","ZLeB `FbN",MB_ICONINFORMATION | MB_YESNO) == IDNO)
			return(FALSE);
	}

	m_pathOptions.SetConfig("EnableIndex",m_index);
	m_pathOptions.SetConfig("EnableWebDAV",m_webdav);
	m_pathOptions.SetConfig("EnableSSICGI",m_ssicgi);
	m_pathOptions.SetConfig("EnableBandWidthLimit",m_bandwidth);
	m_pathOptions.SetConfig("EnableWrite",m_write);
	m_pathOptions.SetConfig("EnableHiddenFile",m_hidden);

	m_pathOptions.SetConfig("AcceptHTTP",m_http);
	m_pathOptions.SetConfig("AcceptHTTPS",m_https);


	return CPropertyPage::OnKillActive();
}
