// PathPage4.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "PathPage4.h"
#include "StringCompare.h"
#include "FileSelectDialog.h"

// CPathPage4 _CAO

IMPLEMENT_DYNAMIC(CPathPage4, CPropertyPage)
CPathPage4::CPathPage4(CWorkspaceAccess path)
	: CPropertyPage(CPathPage4::IDD)
	, m_enable(FALSE)
	, m_acceptEdit(_T(""))
	, m_deniedEdit(_T(""))
	, m_testEdit(_T(""))
{
	m_kickSetting = path.GetAccess("Kick");;
	m_pathSetting = path;
}

CPathPage4::~CPathPage4()
{
}

void CPathPage4::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_CHECK1, m_enable);
	DDX_Control(pDX, IDC_ACCEPT, m_accept);
	DDX_Control(pDX, IDC_DENIED, m_denied);
	DDX_Text(pDX, IDC_ACCEPT_EDIT, m_acceptEdit);
	DDX_Text(pDX, IDC_DENIED_EDIT, m_deniedEdit);
	DDX_Text(pDX, IDC_EDIT3, m_testEdit);
}


BEGIN_MESSAGE_MAP(CPathPage4, CPropertyPage)
	ON_BN_CLICKED(IDC_ACCEPT_ADD, OnBnClickedAcceptAdd)
	ON_BN_CLICKED(IDC_ACCEPT_DEL, OnBnClickedAcceptDel)
	ON_BN_CLICKED(IDC_DENIED_ADD, OnBnClickedDeniedAdd)
	ON_BN_CLICKED(IDC_DENIED_DEL, OnBnClickedDeniedDel)
	ON_BN_CLICKED(IDC_TEST, OnBnClickedTest)
	ON_BN_CLICKED(IDC_ACCEPT_IMPORT, OnBnClickedAcceptImport)
	ON_BN_CLICKED(IDC_DENIED_IMPORT, OnBnClickedDeniedImport)
END_MESSAGE_MAP()


// CPathPage4 bZ[W nh

void CPathPage4::OnBnClickedAcceptAdd()
{
	UpdateData();

	if(IsIP(m_acceptEdit))
	{
		CStringListCtrl::CListItem	add;

		add.m_text = m_acceptEdit;
		add.m_image = 0;
		m_accept.Add(add,1);
		m_accept.UpdateList();
	}
}

void CPathPage4::OnBnClickedAcceptDel()
{
	m_accept.DeleteSelectedItem();
	m_accept.UpdateList();
}

void CPathPage4::OnBnClickedDeniedAdd()
{
	UpdateData();

	if(IsIP(m_deniedEdit))
	{
		CStringListCtrl::CListItem	add;

		add.m_text = m_deniedEdit;
		add.m_image = 1;
		m_denied.Add(add,1);
		m_denied.UpdateList();
	}
}

void CPathPage4::OnBnClickedDeniedDel()
{
	m_denied.DeleteSelectedItem();
	m_denied.UpdateList();
}

void CPathPage4::OnBnClickedTest()
{
	UpdateData();

	if(!m_enable)
	{
		MessageBox("ANZXLɂȂĂ܂ASẴAhX̃ANZX܂B","eXg",MB_ICONINFORMATION);
		return;
	}

	if(IsIP(m_testEdit))
	{
		for(int i=0;i<m_denied.GetSize();i++)
		{
			if(CStringCompare::WildCompare(m_denied[i].m_text,m_testEdit))
			{
				MessageBox("~ : " + m_testEdit + " ̃ANZX͋ۂ܂B","eXg",MB_ICONINFORMATION);
				return;
			}
		}

		for(int i=0;i<m_accept.GetSize();i++)
		{
			if(CStringCompare::WildCompare(m_accept[i].m_text,m_testEdit))
			{
				MessageBox(" : " + m_testEdit + " ̃ANZX͋܂B","eXg",MB_ICONINFORMATION);
				return;
			}
		}

		MessageBox("~ : " + m_testEdit + " ̃ANZX͋ۂ܂B","eXg",MB_ICONINFORMATION);
	}
}

BOOL CPathPage4::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	//	C[WXg̏
	m_imageList.Create(16,16,ILC_COLOR8|ILC_MASK,1,1);
	m_imageList.SetBkColor(::GetSysColor(COLOR_WINDOW));
	m_imageList.Add(GET_APP()->LoadIcon(IDI_ACCEPT));
	m_imageList.Add(GET_APP()->LoadIcon(IDI_DENIED));

	CRect	r;
	m_accept.GetClientRect(r);
	m_accept.SetImageList(&m_imageList,LVSIL_SMALL);
	m_accept.InsertColumn(0,_T("zXgAhX"),LVCFMT_LEFT,r.Width()-1);

	//	Xg̓ǂݍ
	{
		CWorkspaceAccess accept = m_kickSetting.GetAccess("Accept");
		CStringArray	list;
		accept.GetAllKey(list);
		for(int i=0;i<list.GetSize();i++)
		{
			CStringListCtrl::CListItem	add;

			add.m_text = accept.GetConfig(list[i],"");
			add.m_image = 0;
			m_accept.Add(add,1);
		}
	}

	m_denied.GetClientRect(r);
	m_denied.SetImageList(&m_imageList,LVSIL_SMALL);
	m_denied.InsertColumn(0,_T("zXgAhX"),LVCFMT_LEFT,r.Width()-1);

	//	sXg̓ǂݍ
	{
		CWorkspaceAccess denied = m_kickSetting.GetAccess("Denied");
		CStringArray	list;
		denied.GetAllKey(list);
		for(int i=0;i<list.GetSize();i++)
		{
			CStringListCtrl::CListItem	add;

			add.m_text = denied.GetConfig(list[i],"");
			add.m_image = 1;
			m_denied.Add(add,1);
		}
	}

	m_accept.UpdateList();
	m_denied.UpdateList();
	m_enable = m_pathSetting.GetConfig("Options::EnableHostKick",0);
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

BOOL CPathPage4::OnKillActive()
{
	UpdateData(TRUE);
	m_pathSetting.SetConfig("Options::EnableHostKick",m_enable);

	//	[U[̏o
	m_kickSetting.DeleteNode("Accept");
	CWorkspaceAccess accept = m_kickSetting.GetAccess("Accept");
	for(int i=0;i<m_accept.GetSize();i++)
		accept.SetConfig(m_accept[i].m_text,m_accept[i].m_text);

	//	s[U[̏o
	m_kickSetting.DeleteNode("Denied");
	CWorkspaceAccess denied = m_kickSetting.GetAccess("Denied");
	for(int i=0;i<m_denied.GetSize();i++)
		denied.SetConfig(m_denied[i].m_text,m_denied[i].m_text);

	return CPropertyPage::OnKillActive();
}


int CPathPage4::IsIP(CString ip,int alert)
{
	int	split=0;

	if(ip.IsEmpty())
		goto error;

	for(int i=0;i<4;i++)
	{
		CString val = ip.Tokenize(".",split);
		if(val.IsEmpty())
			goto error;

		//	ꂽH
		if(val != "*" && val != "?")
		{
			for(int j=0;j<val.GetLength();j++)
				if(val[j] < '0' || val[j] > '9')
					goto error;
		}
	}

	if(split != ip.GetLength()+1)
		goto error;

	return(1);

error:
	if(alert)
		MessageBox("IPAhX́Au192.168.0.1v̂悤Ɂu*.*.*.*v̌`œ͂ĂB\r\nƁu*vAu?vȊO͎gpł܂B","IP",MB_ICONSTOP);
	return(0);
}

void CPathPage4::OnBnClickedAcceptImport()
{
	CStringArray list;;
	if(Import(list))
	{
		for(int i=0;i<list.GetSize();i++)
		{
			CStringListCtrl::CListItem	add;

			add.m_text = list[i];
			add.m_image = 0;
			m_accept.Add(add,1);
		}
		m_accept.UpdateList();
	}
}

void CPathPage4::OnBnClickedDeniedImport()
{
	CStringArray list;;
	if(Import(list))
	{
		for(int i=0;i<list.GetSize();i++)
		{
			CStringListCtrl::CListItem	add;

			add.m_text = list[i];
			add.m_image = 1;
			m_denied.Add(add,1);
		}
		m_denied.UpdateList();
	}
}

//	C|[gs
int CPathPage4::Import(CStringArray &list)
{
	CFileSelectDialog	sel(m_hWnd);
	sel.AddExt("*.csv","CSVt@C (*.csv)");
	sel.AddExt("*.txt","eLXgt@C (*.txt)");

	if(sel.OpenFile() == IDOK)
	{
		FILE *in = NULL;
		if(!_tfopen_s(&in, sel.GetFilePath(),_T("rt")))
		{
			CString	text;

			fseek(in,0,SEEK_END);
			int len = ftell(in);
			fseek(in,0,SEEK_SET);

			int readed = (int)fread(text.GetBuffer(len + 1),1,len,in);
			text.ReleaseBufferSetLength(readed);
			fclose(in);


			//	
			CString	line;
			int		index = 0;
			while(1)
			{
				line = text.Tokenize("\n",index);
				line.Trim(",:");
				if(line.IsEmpty())
					break;
				
				if(IsIP(line,0))
				{
					TRACE("%s\n",line);
					list.Add(line);
				}
			}
		}
	}



	return((int)list.GetSize());
}

