// SIICGIPage1.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "SIICGIPage1.h"
#include "FileSelectDialog.h"


// CSIICGIPage1 _CAO

IMPLEMENT_DYNAMIC(CSIICGIPage1, CPropertyPage)
CSIICGIPage1::CSIICGIPage1()
	: CPropertyPage(CSIICGIPage1::IDD)
	, m_ext(_T(""))
	, m_path(_T(""))
	, m_exe(FALSE)
{
}

CSIICGIPage1::~CSIICGIPage1()
{
}

void CSIICGIPage1::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST, m_list);
	DDX_Text(pDX, IDC_WXT, m_ext);
	DDX_Control(pDX, IDC_HEADER, m_header);
	DDX_Text(pDX, IDC_PATH, m_path);
	DDX_Check(pDX, IDC_EXE, m_exe);
	DDX_Control(pDX, IDC_UPDATE, m_update);
}


BEGIN_MESSAGE_MAP(CSIICGIPage1, CPropertyPage)
	ON_BN_CLICKED(IDC_ADD, OnBnClickedAdd)
	ON_BN_CLICKED(IDC_DEL, OnBnClickedDel)
	ON_BN_CLICKED(IDC_BROWS, OnBnClickedBrows)
	ON_BN_CLICKED(IDC_EXE, OnBnClickedExe)
	ON_BN_CLICKED(IDC_ADD_OPT, OnBnClickedAddOpt)
	ON_NOTIFY(NM_CLICK, IDC_LIST, OnNMClickList)
	ON_BN_CLICKED(IDC_UPDATE, OnBnClickedUpdate)
	ON_BN_CLICKED(IDC_UP, OnBnClickedUp)
	ON_BN_CLICKED(IDC_DOWN, OnBnClickedDown)
END_MESSAGE_MAP()


// CSIICGIPage1 bZ[W nh

void CSIICGIPage1::OnBnClickedAdd()
{
	UpdateData();

	CString	header;
	m_header.GetWindowText(header);

	//	`FbN
	if(m_ext.IsEmpty() || m_path.IsEmpty())
	{
		MessageBox("͂ĂȂڂ܂B");
		return;
	}

	CStringListCtrl::CListItem	add;

	add.m_text = m_ext;

	if(m_exe == 0)
		add.m_subText.Add(header);
	else
		add.m_subText.Add("- st@C -");
	add.m_data = m_exe;

	add.m_subText.Add(m_path);
	m_list.Add(add,FALSE);
	m_list.UpdateList(FALSE);

}

//	㏑
void CSIICGIPage1::OnBnClickedUpdate()
{
	int index = m_list.GetFirstSelect();

	if(index != -1)
	{
		UpdateData();

		CString	header;
		m_header.GetWindowText(header);

		//	`FbN
		if(m_ext.IsEmpty() || m_path.IsEmpty())
		{
			MessageBox("͂ĂȂڂ܂B");
			return;
		}

		CStringListCtrl::CListItem	add;

		add.m_text = m_ext;

		if(m_exe == 0)
			add.m_subText.Add(header);
		else
			add.m_subText.Add("- st@C -");
		add.m_data = m_exe;

		add.m_subText.Add(m_path);
		m_list[index] = add;
		m_list.UpdateList(FALSE);
	}
}

void CSIICGIPage1::OnBnClickedDel()
{
	m_list.DeleteSelectedItem();
	m_list.UpdateList(FALSE);
}

void CSIICGIPage1::OnBnClickedBrows()
{
	UpdateData();

	CFileSelectDialog	sel(m_hWnd);
	sel.AddExt("*.exe","st@C (*.exe)");

	if(sel.OpenFile() == IDOK)
		m_path = sel.GetFilePath();

	UpdateData(FALSE);
}

BOOL CSIICGIPage1::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	m_update.EnableWindow(FALSE);

	m_imageList.Create(16,16,ILC_COLOR8|ILC_MASK,1,1);
	m_imageList.SetBkColor(::GetSysColor(COLOR_WINDOW));
	m_imageList.Add(GET_APP()->LoadIcon(IDI_SCRIPT));

	CRect	r;
	m_list.GetClientRect(r);
	m_list.SetImageList(&m_imageList,LVSIL_SMALL);
	m_list.InsertColumn(0,_T("gq"),LVCFMT_LEFT,50);
	m_list.InsertColumn(1,_T("t@Cwb_"),LVCFMT_LEFT,100);
	m_list.InsertColumn(2,_T("CGIsvO"),LVCFMT_LEFT,r.Width()-150);


	CWorkspaceAccess cgi = GET_APP()->m_setting.GetAccess("CGI");
	CStringArray	list;
	cgi.GetAllSubNode(list);
	for(int i=0;i<list.GetSize();i++)
	{
		CWorkspaceAccess	item = cgi.GetAccess(list[i]);

		CStringListCtrl::CListItem	add;

		add.m_text = item.GetConfig("FileExt","");

		if(item.GetConfig("ExecuteFile",0) == 0)
			add.m_subText.Add(item.GetConfig("FileHeader",""));
		else
			add.m_subText.Add("- st@C -");
		add.m_data = item.GetConfig("ExecuteFile",0);

		add.m_subText.Add(item.GetConfig("Command",""));
		m_list.Add(add,FALSE);
	}

	m_list.UpdateList(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

BOOL CSIICGIPage1::OnKillActive()
{
	CString	str;

	//	o
	GET_APP()->m_setting.DeleteNode("CGI");
	CWorkspaceAccess cgi = GET_APP()->m_setting.GetAccess("CGI");

	int	i,len = (int)m_list.GetSize();
	for(i=0;i<len;i++)
	{
		str.Format("CGI_%02d",i);

		CWorkspaceAccess	item = cgi.GetAccess(str);
		item.SetConfig("FileExt",m_list[i].m_text);
		item.SetConfig("FileHeader",m_list[i].m_subText[0]);
		item.SetConfig("Command",m_list[i].m_subText[1]);
		item.SetConfig("ExecuteFile",(int)m_list[i].m_data);
	}

	return CPropertyPage::OnKillActive();
}

void CSIICGIPage1::OnBnClickedExe()
{
	UpdateData();
	if(m_exe)
		m_header.EnableWindow(FALSE);
	else
		m_header.EnableWindow(TRUE);
}

void CSIICGIPage1::OnBnClickedAddOpt()
{
	UpdateData();
	m_path.Trim();
	m_path += " %FilePath% %Query%";
	m_path.Trim();
	UpdateData(FALSE);
}

void CSIICGIPage1::OnNMClickList(NMHDR *pNMHDR, LRESULT *pResult)
{
	int index = m_list.GetFirstSelect();

	if(index != -1)
	{
		UpdateData();
		m_update.EnableWindow(TRUE);
		
		m_ext = m_list[index].m_text;
		m_header.SetWindowText(m_list[index].m_subText[0]);
		m_path = m_list[index].m_subText[1];
		m_exe = m_list[index].m_data;

		if(m_exe)
			m_header.EnableWindow(FALSE);
		else
			m_header.EnableWindow(TRUE);

		UpdateData(FALSE);
	}
	else
		m_update.EnableWindow(FALSE);
	*pResult = 0;

	UpdateData(FALSE);
}


void CSIICGIPage1::OnBnClickedUp()
{
	int index = m_list.GetFirstSelect();
	if(index > 0)
	{
		CStringListCtrl::CListItem	swap = m_list[index];
		m_list[index] = m_list[index-1];
		m_list[index-1] = swap;
		m_list.UpdateList(FALSE);
		m_list.SelectItem(index-1);
	}
	else
		MessageBeep(MB_OK);
}

void CSIICGIPage1::OnBnClickedDown()
{
	int index = m_list.GetFirstSelect();
	if(index != -1 && index < m_list.GetSize() - 1)
	{
		CStringListCtrl::CListItem	swap = m_list[index];
		m_list[index] = m_list[index+1];
		m_list[index+1] = swap;
		m_list.UpdateList(FALSE);
		m_list.SelectItem(index+1);
	}
	else
		MessageBeep(MB_OK);
}
