// ServerController.cpp : AvP[ṼNX`܂B
//

#include "stdafx.h"
#include "ServerController.h"
#include "MainFrm.h"
#include "afxwin.h"
#include "Mmsystem.h"
#include "ClickedStatic.h"
#include ".\servercontroller.h"
#include "SystemServiceControl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CServerControllerApp

BEGIN_MESSAGE_MAP(CServerControllerApp, CWinApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_START, OnFileStart)
	ON_COMMAND(ID_FILE_LOAD, OnFileLoad)
	ON_COMMAND(ID_FILE_EXPORT, OnFileExport)
	ON_COMMAND(ID_HELP_MANUAL, OnHelpManual)
	ON_COMMAND(ID_HELP_HOMEPAGE, OnHelpHomepage)
END_MESSAGE_MAP()


// CServerControllerApp RXgNV

CServerControllerApp::CServerControllerApp()
	: m_settingRoot(_T("04WebServer"))
{
	m_wantRestart = 0;
	m_mutex = NULL;
}

CServerControllerApp::~CServerControllerApp()
{
	SAFE_CLOSE_HANDLE(m_mutex);
}

// B CServerControllerApp IuWFNgłB

CServerControllerApp theApp;

// CServerControllerApp 

BOOL CServerControllerApp::InitInstance()
{
	CoInitialize(NULL);
	InitCommonControls();
	CWinApp::InitInstance();

	// OLE Cu܂B
	if (!AfxOleInit())
	{
		AfxMessageBox(IDP_OLE_INIT_FAILED);
		return FALSE;
	}
	AfxEnableControlContainer();
	SetRegistryKey(_T("Soft3304"));

	//	dN
	if(CheckOther())
	{
		AfxMessageBox("T[oRg[͂łɋNłAdNł܂B",MB_ICONSTOP);
		return FALSE;
	}

	//	T[õ[h
	if(TryOpenPipe())
	{
		//	T[oJn
		if(StartServerProcess())
		{
			AfxMessageBox("T[oNł܂łB\r\n04WebServer.exej󂳂Ă\܂B",MB_ICONSTOP);
			return FALSE;
		}

		//	N҂
		if(TryOpenPipe(50))
		{
			AfxMessageBox("T[oƂ̒ʐMJnł܂łB\r\n04WebServer.exej󂳂Ă\܂B",MB_ICONSTOP);
			return FALSE;
		}
	}

	//	ݒ[h
	LoadSetting();

	//	T[osJn
	if(m_serverControl.IsRunning()==0)
		m_serverControl.StartServer();

	//	EChE쐬
	CMainFrame* pFrame = new CMainFrame;
	m_pMainWnd = pFrame;

	pFrame->LoadFrame(IDR_MAINFRAME,
		WS_OVERLAPPEDWINDOW, NULL,
		NULL);

	((CMainFrame *)pFrame)->PopWindowStat();
	((CMainFrame *)pFrame)->UpdateWindow();

	return TRUE;
}

/*!
	T[oN
*/
int CServerControllerApp::StartServerProcess()
{
	//	T[rXȂN
	if(CSystemServiceControl::ServiceInstalled())
	{
		if(CSystemServiceControl::StartSystemService())
			return(-1);
	}
	else
	{
		CString path = GetAppPath() + "04WebServer.exe";
		if((int)::ShellExecute(0, _T("open"), path.GetBuffer(0),  _T("/Application"), 0, SW_SHOWNORMAL) < 32)
			return(-1);
	}
	return(0);
}

/*!
	ʐMJn
*/
int CServerControllerApp::TryOpenPipe(int loop)
{
	//	N҂
	for(int i=0;i<loop;i++)
	{
		if(!m_serverControl.OpenServerControl())
			return(0);
		Sleep(100);
	}
	return(-1);
}



//	W[pX擾
CString CServerControllerApp::GetAppPath()
{
	char	s[MAX_PATH+1];
	DWORD len = GetModuleFileName(NULL, s, MAX_PATH);

	while ( s[len--]!='\\' && len!=0 )
		;
	s[len+2] = '\0';        // }[NŏI点

	return(s);
}

//	ݒ胍[h
void CServerControllerApp::LoadSetting()
{
	//	ݒ̈擾
	CString path = m_serverControl.GetServerRoot();
	if(!path.IsEmpty())
		m_settingRoot.LoadFromXMLFile(path + "04WebServer.xml");
	m_setting = m_settingRoot.GetAccess("Setting");
}

//	ݒZ[u
void CServerControllerApp::SaveSetting()
{
	CString path = m_serverControl.GetServerRoot();
	if(!path.IsEmpty())
		m_settingRoot.SaveToXMLFile(path + "04WebServer.xml");
	m_wantRestart = 1;
	m_pMainWnd->Invalidate();
}

// CServerControllerApp bZ[W nh



// AvP[Ṽo[WɎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	enum { IDD = IDD_ABOUTBOX };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	
	CFont	m_bold;

// 
protected:
	DECLARE_MESSAGE_MAP()
public:
	CStatic m_label;
	CStatic m_copyright;
	afx_msg void OnStnClickedSoft3304();
	afx_msg void OnStnClickedLogo();
	virtual BOOL OnInitDialog();
	CString m_edit;
	CClickedStatic m_soft3304;
	CClickedStatic m_04webserver;
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
, m_edit(_T(""))
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LABEL, m_label);
	DDX_Control(pDX, IDC_COPYRIGHT, m_copyright);
	DDX_Text(pDX, IDC_LOG, m_edit);
	DDX_Control(pDX, IDC_SOFT3304, m_soft3304);
	DDX_Control(pDX, IDC_LOGO, m_04webserver);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	ON_STN_CLICKED(IDC_SOFT3304, OnStnClickedSoft3304)
	ON_STN_CLICKED(IDC_LOGO, OnStnClickedLogo)
END_MESSAGE_MAP()

//	
BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_bold.CreateFont(12,0,0,0,FW_BOLD,FALSE,FALSE,FALSE,
						SHIFTJIS_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
						DEFAULT_QUALITY,DEFAULT_PITCH,"");
	m_label.SetFont(&m_bold);
	m_label.SetWindowText(PRODUCT_VERSION_STRING);
	m_copyright.SetWindowText(PRODUCT_COPYRIGHT);


	//	O̎擾
	HRSRC res = FindResource(NULL,MAKEINTRESOURCE(IDR_UPDATE_LOG),"TEXT");
	int	size = SizeofResource(NULL,res);
	HGLOBAL data = LoadResource(NULL,res);

	if(data!=NULL)
	{
		char * buf = m_edit.GetBuffer(size + 1);
		memcpy(buf,data,size);
		buf[size] = 0;
		m_edit.ReleaseBuffer();
	}

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

//	o[i[NbNP
void CAboutDlg::OnStnClickedSoft3304()
{
	GET_APP()->ClickSound();

	CString	url;
	url.LoadString(IDS_URL_SOFT3304);
	::ShellExecute(0, _T("open"), url.GetBuffer(0), 0, 0, SW_SHOWNORMAL);
}

//	o[i[NbNQ
void CAboutDlg::OnStnClickedLogo()
{
	GET_APP()->ClickSound();

	CString	url;
	url.LoadString(IDS_URL_04WEBSERVER);
	::ShellExecute(0, _T("open"), url.GetBuffer(0), 0, 0, SW_SHOWNORMAL);
}


// _CAOs邽߂̃AvP[V R}h
void CServerControllerApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}


// CServerControllerApp bZ[W nh


int CServerControllerApp::ExitInstance()
{
	//	T[o~
	if(m_serverControl.IsRunning() == 1 && m_serverControl.IsService() == 0)
		m_serverControl.StopServer();

	m_serverControl.CloseServerControl();
	CoUninitialize();
	return CWinApp::ExitInstance();
}

//	u擾
CString	CServerControllerApp::GetPathSwap(CString path)
{
	CWorkspace			swap;
	CWorkspaceAccess	swapAccess = swap.GetAccess("Swap");

	//	T[o[l[
	swapAccess.SetConfig("ServerName","04WebServer");

	//	T[o[[g
	swapAccess.SetConfig("ServerRoot",m_serverControl.GetServerRoot());

	return(swapAccess.GetKeySwapString(path));
}

//	ݒޔ
void CServerControllerApp::PushSetting()
{
	CWorkspaceAccess	push = m_settingPush.GetAccess("Setting");
	push.Copy(m_setting);
}

//	ݒ蕜A
void CServerControllerApp::PopSetting()
{
	CWorkspaceAccess	pop = m_settingPush.GetAccess("Setting");
	m_setting.Copy(pop);
}


//	T[oċN
void CServerControllerApp::OnFileStart()
{
	m_serverControl.StartServer();
	m_wantRestart = 0;
	m_pMainWnd->Invalidate();
}

//	ݒ̓ǂݍ
void CServerControllerApp::OnFileLoad()
{
	CFileDialog	fdialog(TRUE,".xml",NULL,0,"XML Files (*.xml)|*.xml||");

	if(fdialog.DoModal()!=IDOK)
		return;

	CWorkspace	load(_T("04WebServer"));
	if(load.LoadFromXMLFile(fdialog.GetPathName()) ||
		load.GetAccess("Setting").GetConfig("Basic::Port","")=="")
	{
		AfxMessageBox("t@CُłB",MB_ICONSTOP);
		return;
	}

	//	ݒ̈擾
	m_settingRoot.LoadFromXMLFile(fdialog.GetPathName());
	m_setting = m_settingRoot.GetAccess("Setting");
	SaveSetting();
}

//	ݒ̕ۑ
void CServerControllerApp::OnFileExport()
{
	CFileDialog	fdialog(FALSE,".xml","04WebServer.xml",OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,"XML Files (*.xml)|*.xml||");

	if(fdialog.DoModal()!=IDOK)
		return;

	m_settingRoot.SaveToXMLFile(fdialog.GetPathName());
}


//	NbN
void CServerControllerApp::ClickSound()
{
	::PlaySound((LPCSTR)IDR_CLICK,AfxGetApp()->m_hInstance,SND_RESOURCE | SND_ASYNC | SND_NODEFAULT);
}


//	}jA\
void CServerControllerApp::OnHelpManual()
{
	::ShellExecute(0, _T("open"), GET_APP()->GetAppPath() + "manual.html", 0, 0, SW_SHOWNORMAL);
}

//	z[y[WփWv
void CServerControllerApp::OnHelpHomepage()
{
	CString	url;
	url.LoadString(IDS_URL_04WEBSERVER);
	::ShellExecute(0, _T("open"), url.GetBuffer(0), 0, 0, SW_SHOWNORMAL);
}



//	dÑ`FbN
int CServerControllerApp::CheckOther()
{
	//	ZLeBݒ
	m_mutex = ::CreateMutex( NULL, FALSE, _T(ACTIVE_MUTEX_NAME) );
	if( ::GetLastError() == ERROR_ALREADY_EXISTS )
	{
		::CloseHandle(m_mutex);
		m_mutex = NULL;
		return TRUE;
	}
	TRACE("%x", GetLastError());
	return FALSE;
}
