#include "StdAfx.h"
#include "serverinfoview.h"
#include "ServerController.h"

#define	TEXT_LEFT	2

CServerInfoView::CServerInfoView(void)
{
}

CServerInfoView::~CServerInfoView(void)
{
}
BEGIN_MESSAGE_MAP(CServerInfoView, CMainViewBase)
	ON_WM_PAINT()
	ON_WM_CREATE()
	ON_WM_TIMER()
END_MESSAGE_MAP()

void CServerInfoView::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	DrawAll(&dc);
}

//	ĕ`
void CServerInfoView::DrawAll(CDC *dc)
{
	dc->SetBkMode(TRANSPARENT);

	//	N
	if(GET_APP()->m_serverControl.IsRunning())
	{
		SetInfoActive(TRUE);
		DrawText(dc,TEXT_LEFT,10,"T[o",GET_APP()->m_serverControl.GetServerErrorString());
	}
	else
	{
		SetInfoActive(FALSE);
		DrawText(dc,TEXT_LEFT,10,"T[o","NG[ : " + GET_APP()->m_serverControl.GetServerErrorString(),TRUE);
	}

	//	ڍ׏
	if(GET_APP()->m_serverControl.IsRunning())
	{
		CWorkspace	infoRoot;
		GET_APP()->m_serverControl.GetServerInfo(infoRoot.GetAccess(""));
		CWorkspaceAccess info = infoRoot.GetAccess("ServerInfo");

		//	VOj`擾
		CString ServerSignature = info.GetConfig("ServerName","") + "/" + info.GetConfig("ServerVersion","");
		if(ServerSignature != info.GetConfig("ServerSignature",""))
			ServerSignature += " (" + info.GetConfig("ServerSignature","") + ")";

		DrawText(dc,TEXT_LEFT,50 ,"T[oEo[W", ServerSignature);
		if(GET_APP()->m_serverControl.IsService())
			DrawText(dc,TEXT_LEFT,90 ,"T[oE^Cv","VXe T[rX");
		else
			DrawText(dc,TEXT_LEFT,90 ,"T[oE^Cv","X^hA AvP[V");
		DrawText(dc,TEXT_LEFT,130 ,"T[oE[g",info.GetConfig("ServerRoot",""));

		DrawText(dc,TEXT_LEFT,190,"ݏ̐ڑ",info.GetConfig("CurrentConnection","0") + " ڑ");
		DrawText(dc,TEXT_LEFT,230,"T[oNĂ猻݂܂ł̐ڑ",info.GetConfig("AllConnected","0") + " ڑ");

		__int64	send = _atoi64(info.GetConfig("AllSendSize","0"));
		__int64	recv = _atoi64(info.GetConfig("AllRecvSize","0"));
		DrawText(dc,TEXT_LEFT,270,"T[oNĂ猻݂܂ł̍v]",GetTransText(send,recv));
	
		DrawText(dc,TEXT_LEFT,310,"ߋPԂ̐ڑ",info.GetConfig("Connected1Hour","0") + " ڑ");

		send = _atoi64(info.GetConfig("SendSize1Hour","0"));
		recv = _atoi64(info.GetConfig("RecvSize1Hour","0"));
		DrawText(dc,TEXT_LEFT,350,"ߋPԂ̍v]",GetTransText(send,recv));
	}
}


//	ꂽ擾
CString CServerInfoView::GetTransText(__int64 send,__int64 recv)
{
	CString	line,str;

	if(send < 10240)
		str.Format("Me : %d oCgA",send);
	else if(send < 10485760L)
		str.Format("Me : %d KoCgA",send/1024);
	else if(send < 10737418240L)
		str.Format("Me : %d MoCgA",send/1048576L);
	else
		str.Format("Me : %d GoCgA",send/1073741824L);
	line = str;

	if(recv < 10240)
		str.Format("Me : %d oCg",recv);
	else if(recv < 10485760L)
		str.Format("Me : %d KoCg",recv/1024);
	else if(recv < 10737418240L)
		str.Format("Me : %d MoCg",recv/1048576L);
	else
		str.Format("Me : %d GoCg",recv/1073741824L);
	line += str;

	return(line);
}

//	eLXgo
void CServerInfoView::DrawText(CDC *dc,int x,int y,CString label,CString text,int alert)
{
	CFontSelector bold(dc,GET_GDI().m_fBold);

	dc->SetTextColor(TEXT_COLOR_BLUE);
	dc->TextOut(x,y,label);

	CFontSelector normal(dc,GET_GDI().m_fNormal);
	if(alert)
		dc->SetTextColor(TEXT_COLOR_RED);
	else
		dc->SetTextColor(TEXT_COLOR_BLACK);
	EraseText(x + 14,y + 16,dc);
	dc->TextOut(x + 14,y + 16,text);
}


void CServerInfoView::EraseText(int x,int y,CDC *dc)
{
	CRect	client;
	GetClientRect(client);

	CRect	r(x,y,client.right,y+16);
	dc->FillSolidRect(r,TEXT_COLOR_WHITE);
}

int CServerInfoView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMainViewBase::OnCreate(lpCreateStruct) == -1)
		return -1;

	SetTimer(200,1000,NULL);

	return 0;
}

void CServerInfoView::OnTimer(UINT nIDEvent)
{
	//	ŏ͍XVȂ
	if(!AfxGetApp()->GetMainWnd()->IsIconic())
	{
		CClientDC 	dc(this);
		DrawAll(&dc);
	}

	CMainViewBase::OnTimer(nIDEvent);
}

//	
CString CServerInfoView::ToString()
{
	CString	text;

	CWorkspace	infoRoot;
	GET_APP()->m_serverControl.GetServerInfo(infoRoot.GetAccess(""));
	CWorkspaceAccess info = infoRoot.GetAccess("ServerInfo");

	text += "T[o\r\n@";
	text += GET_APP()->m_serverControl.GetServerErrorString();
	text += "\r\n\r\n";

	text += "T[oEo[W\r\n@";
	text += info.GetConfig("ServerSignature","");
	text += "\r\n\r\n";

	if(GET_APP()->m_serverControl.IsService())
		text += "T[oE^Cv\r\n@VXe T[rX\r\n\r\n";
	else
		text += "T[oE^Cv\r\n@X^hA AvP[V\r\n\r\n";

	text += "T[oE[g\r\n@";
	text += info.GetConfig("ServerRoot","");
	text += "\r\n\r\n";

	text += "ݏ̐ڑ\r\n@";
	text += info.GetConfig("CurrentConnection","0");
	text += "\r\n\r\n";

	text += "T[oNĂ猻݂܂ł̐ڑ\r\n@";
	text += info.GetConfig("AllConnected","0");
	text += "\r\n\r\n";

	__int64	send = _atoi64(info.GetConfig("AllSendSize","0"));
	__int64	recv = _atoi64(info.GetConfig("AllRecvSize","0"));

	text += "T[oNĂ猻݂܂ł̍v]\r\n@";
	text += GetTransText(send,recv);
	text += "\r\n\r\n";

	text += "ߋPԂ̐ڑ\r\n@";
	text += info.GetConfig("Connected1Hour","0") + " ڑ";
	text += "\r\n\r\n";

	send = _atoi64(info.GetConfig("SendSize1Hour","0"));
	recv = _atoi64(info.GetConfig("RecvSize1Hour","0"));
	text += "ߋPԂ̍v]\r\n@";
	text += GetTransText(send,recv);
	text += "\r\n\r\n";

	return(text);
}

