// ServerPage4.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "ServerPage4.h"
#include "FileSelectDialog.h"
#include "KeyGenDialog.h"
#include "TextTools.h"


// CServerPage4 _CAO

IMPLEMENT_DYNAMIC(CServerPage4, CPropertyPage)
CServerPage4::CServerPage4()
	: CPropertyPage(CServerPage4::IDD)
	, m_enable(FALSE)
	, m_port(_T(""))
	, m_key(_T(""))
	, m_pass(_T(""))
	, m_ca(_T(""))
{
}

CServerPage4::~CServerPage4()
{
}

void CServerPage4::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Check(pDX, IDC_ENABLE, m_enable);
	DDX_Text(pDX, IDC_PORT, m_port);
	DDX_Text(pDX, IDC_KEY, m_key);
	DDX_Text(pDX, IDC_PASS, m_pass);
	DDX_Text(pDX, IDC_CA, m_ca);
}


BEGIN_MESSAGE_MAP(CServerPage4, CPropertyPage)
	ON_BN_CLICKED(IDC_MAKE, OnBnClickedMake)
	ON_BN_CLICKED(IDC_BROWS1, OnBnClickedBrows1)
	ON_BN_CLICKED(IDC_BROWS2, OnBnClickedBrows2)
END_MESSAGE_MAP()


// CServerPage4 bZ[W nh

void CServerPage4::OnBnClickedMake()
{
	CKeyGenDialog	gen;
	gen.DoModal();
}

void CServerPage4::OnBnClickedBrows1()
{
	UpdateData();

	CFileSelectDialog	sel(m_hWnd);
	sel.AddExt("*.pem","PEMt@C (*.pem)");
	sel.AddExt("*.*","SẴt@C (*.*)");

	if(sel.OpenFile() == IDOK)
		m_key = sel.GetFilePath();

	UpdateData(FALSE);
}

void CServerPage4::OnBnClickedBrows2()
{
	UpdateData();

	CFileSelectDialog	sel(m_hWnd);
	sel.AddExt("*.crt","CRTt@C (*.crt)");
	sel.AddExt("*.pem","PEMt@C (*.pem)");
	sel.AddExt("*.*","SẴt@C (*.*)");

	if(sel.OpenFile() == IDOK)
		m_ca = sel.GetFilePath();

	UpdateData(FALSE);
}



BOOL CServerPage4::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	CWorkspaceAccess	basic = GET_APP()->m_setting.GetAccess("Basic");
	CWorkspaceAccess	ssl = GET_APP()->m_setting.GetAccess("SSL");

	m_enable = basic.GetConfig("EnableSSL",0);
	m_port = ssl.GetConfig("Port", _T("443"));
	m_key = ssl.GetConfig("PrivateKey","%ServerRoot%SSLKey\\04WebServer.pem");
	m_pass = ssl.GetConfig("Password","test");
	m_ca = ssl.GetConfig("Certificate","%ServerRoot%SSLKey\\04WebServer.crt");

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

BOOL CServerPage4::OnKillActive()
{
	CWorkspaceAccess	basic = GET_APP()->m_setting.GetAccess("Basic");
	CWorkspaceAccess	ssl = GET_APP()->m_setting.GetAccess("SSL");

	UpdateData(TRUE);

	//	|[g̏
	CStringArray	ports;
	CTextTools::GetAllToken(m_port, ports, ",", TRUE);
	m_port.Empty();
	for(int i=0;i<ports.GetSize();i++)
	{
		if(atoi(ports[i]) != 0)
		{
			if(!m_port.IsEmpty())
				m_port += _T(", ");
			m_port += ports[i];
		}
	}

	//	|[g͐H
	if(m_port.IsEmpty())
	{
		MessageBox(_T("|[gݒ肪ُł"));
		return(FALSE);
	}

	basic.SetConfig("EnableSSL",m_enable);
	ssl.SetConfig("Port",m_port);
	ssl.SetConfig("PrivateKey",m_key);
	ssl.SetConfig("Password",m_pass);
	ssl.SetConfig("Certificate",m_ca);

	return CPropertyPage::OnKillActive();
}
