// ServerPage5.cpp : t@C
//

#include "stdafx.h"
#include "ServerController.h"
#include "ServerPage5.h"
#include ".\serverpage5.h"


// CServerPage5 _CAO

IMPLEMENT_DYNAMIC(CServerPage5, CPropertyPage)
CServerPage5::CServerPage5()
	: CPropertyPage(CServerPage5::IDD)
	, m_name(_T(""))
{
}

CServerPage5::~CServerPage5()
{
}

void CServerPage5::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_PORT, m_name);
}


BEGIN_MESSAGE_MAP(CServerPage5, CPropertyPage)
	ON_BN_CLICKED(IDC_NAME_NORMAL, OnBnClickedNameNormal)
	ON_BN_CLICKED(IDC_NAME_NETSCAPE, OnBnClickedNameNetscape)
	ON_BN_CLICKED(IDC_NAME_IIS, OnBnClickedNameIis)
	ON_BN_CLICKED(IDC_NAME_APACHE, OnBnClickedNameApache)
END_MESSAGE_MAP()


// CServerPage5 bZ[W nh

BOOL CServerPage5::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	CWorkspaceAccess	setting = GET_APP()->m_setting.GetAccess("Basic");

	m_name = setting.GetConfig("ServerSignature","%ServerName%/%ServerVersion%");
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

BOOL CServerPage5::OnKillActive()
{
	CWorkspaceAccess	setting = GET_APP()->m_setting.GetAccess("Basic");

	UpdateData(TRUE);
	setting.SetConfig("ServerSignature",m_name);

	return CPropertyPage::OnKillActive();
}

//	W
void CServerPage5::OnBnClickedNameNormal()
{
	UpdateData(TRUE);
	m_name = "%ServerName%/%ServerVersion%";
	UpdateData(FALSE);
}

//	Netscape
void CServerPage5::OnBnClickedNameNetscape()
{
	UpdateData(TRUE);
	m_name = "Netscape-Enterprise/4.0";
	UpdateData(FALSE);
}

//	IIS
void CServerPage5::OnBnClickedNameIis()
{
	UpdateData(TRUE);
	m_name = "Microsoft-IIS/6.0";
	UpdateData(FALSE);
}

//	Apache
void CServerPage5::OnBnClickedNameApache()
{
	UpdateData(TRUE);
	m_name = "Apache/1.3.29 (Unix)";
	UpdateData(FALSE);
}
